package bbLib;
import java.lang.Math;

/**
 * La classe mre de toutes les actions que peut effectuer un joueur
 * 
 * @author Pierre Trocm
 * @version 0.2 - 20 Octobre 2003
 */
public abstract class Action
{
    protected int type;
    protected Joueur joueur;
    public final static int Deplacement = 0;
    public final static int Blocage = 1;
    public final static int Pietinement = 2;
    public final static int Sprint = 3;
    public final static int Blitz = 4;
    
    
    

    protected Action(int type, Joueur joueur) throws IllegalActionException{
        this.type = type;
        this.joueur = joueur;
        if(Math.min(joueur.getX(), joueur.getY()) < 0) throw new IllegalActionException();
    }
    
    public abstract void execute()throws IllegalActionException, TouchDownScoredException;
    
    public int getType(){
        return type;
    }
    
    /**
     * Permet de connaitre le signe d'un entier.
     * @param   x l'entier dont on veut connaitre le signe
     * @return  +1, -1 ou 0
     */
    protected int sign(int x){
        if(x > 0) return 1;
        if(x == 0) return 0;
        return -1;
    }

}
