package bbLib;


/**
 * Une classe servant  gerer un dplacement Dclenchable dans le temps
 * 
 * @author Pierre Trocm
 * @version 0.6 - 10 Mai 2004
 */

//MISE EN FORME: supprimer cette classe

public class Deplacement extends Action
{
	private Case destination;
    private int x_dest, y_dest;
    private Joueur joueur;
    private Field field;
    
    public Deplacement(Joueur joueur, Case destination)throws IllegalActionException{
		super(Deplacement, joueur);
		if(!joueur.isStanding()){
			throw new IllegalActionException();
		}
    	field = joueur.getField();
        x_dest = destination.getX();
        y_dest = destination.getY();


        this.joueur = joueur;
    }
    
    
    /**
     * L'action  xcuter lorsque le temps est s'coul.
     * Dplace effctivement le joueur
     * 
     * */
     public void execute()throws IllegalActionException, TouchDownScoredException{
         if( ( x_dest == joueur.getX() )&&( y_dest == joueur.getY() ) ) {
//                cancel();
                return;
            }
        try{
            if (Rules.dodgeTest(joueur) == false) {
            	System.out.println("Echec d jet d'esquive");
                return;
            }
            move();
            if( ( x_dest == joueur.getX() )&&( y_dest == joueur.getY() ) ) {
                System.out.println("Arrive de " + joueur +" dans la case "+ x_dest + ", " + y_dest);                 
//                cancel();
            }
        }
        catch(CaseInexistanteException cie){
            System.out.println("Cette case n'existe pas!!!");
        }
        catch(CaseNonVideException cnve){
            System.out.println("Cette est dja occupe!!!");
        }
    }
    
    /**
     * Effectue completement un mouvement d'une case. 
     * 
     * @thow CaseInexistanteException lorsuqe la case de destination n'existe pas.
     * @throw CaseNonVideException  lorsque la case de destination est occupe
     * */
    private void move() throws CaseNonVideException, IllegalActionException, CaseInexistanteException{
        int diffx = x_dest - joueur.getX();
        int diffy = y_dest - joueur.getY();
        
        int nextX = joueur.getX() + sign(diffx);
        int nextY = joueur.getY() + sign(diffy);

        if(field.getCase(nextX, nextY).getOccupant() == null)
            try{
                field.placeJoueurAt(joueur, nextX, nextY);
                System.out.println( "Dplacement effectu avec succes vers" + field.getCase(nextX, nextY));

            }
            catch(ArrayIndexOutOfBoundsException aioobe){
                throw new CaseInexistanteException(nextX, nextY);
            } catch (JoueurInconnuException e) {
				System.out.println("Cette erreur ne devrait pas arriver");
				e.printStackTrace();
			} catch (IllegalActionException e) {
				e.printStackTrace();
			} catch (CaseNonVideException e) {
				e.printStackTrace();
			} catch (CaseInexistanteException e) {
				e.printStackTrace();
			}
            
        else throw new CaseNonVideException();
    }
}
    

