package bbLib;

/**
 * Une classe servan,t  gerer les pietinements.
 * Ne gere pas encore les Expulsions, ni les Soutients.
 * 
 * @author Pierre Trocm
 * @version 0.2 - 9 Novembre 2003
 */
public class Pietinement extends Action
{
    private Joueur cible;
    private Field field;
    /**
     * Constructor for objects of class Pietinement
     */
    public Pietinement(Joueur joueur, Joueur cible) throws IllegalActionException
    {
        super(Pietinement, joueur);
        this.cible = cible;
        this.field = joueur.getField();
        if(cible.getField() != field){
        	throw new IllegalActionException();
        }
    }

    /**
     * Pietinne.
     * 
     */
    public void execute()
    {
        try{
            Rules.armorRoll(1 + field.soutientContre(cible, joueur) - field.soutientContre(joueur, cible), cible);
            Test refereeTest = new Test(6, 1, field.firstFoulBy( joueur.getTeam() )? 0 : 2);
            if(refereeTest.succeded()){
            	System.out.println(joueur + " a ete vu par l'arbitre. Expulsion!");
            	field.expulse(joueur, false);
            	joueur.turnOverHappened();
            }
        }
        catch(IllegalActionException iae){
            System.out.println("Pietinnement termin suite  une erreur");
        }
        catch(JoueurInconnuException jie){
            System.out.println("Impossible d'expusler le coupabl : il ne joue pas cette partie");
        }
    }
}
