package bbLib;
import java.util.Iterator;
import java.util.Vector;
import java.io.Serializable;
/**
 * Une classe rassemblant tout les joueurs d'une quipe et les methodes pour les
 * grer. <br>
 * 18/05/04 implementation de l'interface nouvellement cre, Team. <br>
 * 30/05/04 Implmentation de MessagingChain. <br>
 * 08/09/04 Ajout d'un SerialVersionUID
 * @author Pierre Trocm
 * @version 0.4 - 8 Septembre 2004
 */
public class Roster implements Serializable, Team, MessagingChain
{
	private static final long serialVersionUID = -5033133704176687922L;
	private final static int FANFACTORPRICE = 10;
	private final static int WIZARDPRICE = 50;
	private final static int CHEERLEADERSPRICE = 10;
	private final static int APOTHECARYPRICE = 50;
	private final static int ASSISTANTPRICE = 10;
	private VectorSet joueurs;
	private int reRolls, fanFactor, cheerleaders, assistantCoach, apothecaries,
			wizards;
	private int treaseaury;
	private String name, coachName;
	public int NBMAX;
	private String race;
	private final int reRollCost;
	private int usedReRolls;
	private MessagingChain nextMessageHandler;

	private Vector<PlayedMatch> playedMatches;
	
	public Roster(String name, String coachName, int reRolls, int fanFactor,
			int cheerleaders, int assistantCoach, int apothecaries,
			int wizards, int treaseaury, int reRollCost, GameVariant gameVariant) {
		NBMAX = gameVariant.getNbMaxPlayersInTeam();
		this.name = name;
		this.coachName = coachName;
		joueurs = new VectorSet(NBMAX);
		this.apothecaries = apothecaries;
		this.wizards = wizards;
		this.reRolls = reRolls;
		this.fanFactor = fanFactor;
		this.cheerleaders = cheerleaders;
		this.assistantCoach = assistantCoach;
		this.reRollCost = reRollCost;
		this.playedMatches = new Vector<PlayedMatch>();
	}
	public void addJoueur(Joueur joueur) {
		if (joueurs.contains(joueur))
			return;
		joueurs.add(joueur);
		joueur.setTeam(this);
	}
	public void addJoueur(Joueur joueur, int numero) {
		if (joueurs.contains(joueur))
			return;
		joueurs.add(numero - 1, joueur);
		joueur.setTeam(this);
	}
	public String toString() {
		String retour = new String();
		String tab = "     ";
		Iterator iterator = joueurs.iterator();
		retour += ("L'quipe " + name + " contient :" + '\n');
		while (iterator.hasNext())
			retour += tab + iterator.next() + '\n';
		return retour;
	}
	public Iterator iterator() {
		return joueurs.iterator();
	}
	public String getName() {
		return name;
	}
	
	/**
	 * Donne acces a un joueur precis de l'equipe.
	 * @param numero le numero du joueur
	 * @return Le joueur portqnt de numero
	 */
	public Joueur getJoueur(int numero) {
		return (Joueur) joueurs.elementAt(numero - 1);
	}
	/**
	 * @return
	 */
	public int getReRolls() {
		return reRolls;
	}
	/**
	 * @return
	 */
	public int getAssistantCoach() {
		return assistantCoach;
	}
	/**
	 * @return
	 */
	public int getCheerleaders() {
		return cheerleaders;
	}
	/**
	 * @return
	 */
	public int getFanFactor() {
		return fanFactor;
	}
	/**
	 * @return
	 */
	public String getRace() {
		return race;
	}
	/**
	 * @return
	 */
	public String getCoachName() {
		return coachName;
	}
	/**
	 * @return
	 */
	public int getRating() {
		int tValue = treaseaury;
		tValue += reRolls * reRollCost;
		tValue += fanFactor * FANFACTORPRICE;
		tValue += cheerleaders * CHEERLEADERSPRICE;
		tValue += assistantCoach * ASSISTANTPRICE;
		tValue += apothecaries * APOTHECARYPRICE;
		tValue += wizards * WIZARDPRICE;
		int tXP = 0;
		Joueur tmpJoueur;
		Iterator iterator = joueurs.iterator();
		while (iterator.hasNext()) {
			tmpJoueur = (Joueur) iterator.next();
			tValue += tmpJoueur.getPrix();
			tXP += tmpJoueur.getXP();
		}
		return tValue / 10 + tXP / 5;
	}
	/**
	 * @return
	 */
	public int getTreaseaury() {
		return treaseaury;
	}
	/**
	 * @return
	 */
	public int getApothecaries() {
		return apothecaries;
	}
	/**
	 * @return
	 */
	public int getReRollCost() {
		return reRollCost;
	}
	/**
	 * @return
	 */
	public int getWizards() {
		return wizards;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.ReRollHandler#askForReRoll()
	 */
	public boolean askForReRoll() {
		if (reRolls > usedReRolls) {
			return nextMessageHandler.askForReRoll();
		} else
			return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.ReRollHandler#usedAReRoll()
	 */
	public void usedAReRoll() {
		usedReRolls++;
		nextMessageHandler.usedAReRoll();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.TurnOverHandler#turnOverHappened()
	 */
	public void turnOverHappened() {
		nextMessageHandler.turnOverHappened();
	}
	public void addMatchReport(PlayedMatch playedMatch) {
		playedMatches.add(playedMatch);
	}
	/**
	 * @return Returns the playedMatches.
	 */
	public Vector getPlayedMatches() {
		return playedMatches;
	}
	/**
	 * @return Returns the nBMAX.
	 */
	public int getNBMAX() {
		return NBMAX;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.MessagingChain#askForFollowUp()
	 */
	public boolean askForFollowUp() {
		return nextMessageHandler.askForFollowUp();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.MessagingChain#choseASquare(bbLib.Positionable[])
	 */
	public int choseASquare(Positionable[] choices) {
		return nextMessageHandler.choseASquare(choices);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.MessagingChain#choseDice(int[])
	 */
	public int choseDice(int[] dicesResult) {
		return nextMessageHandler.choseDice(dicesResult);
	}
	/**
	 * @param nextMessageHandler
	 *            The nextMessageHandler to set.
	 */
	public void setNextMessageHandler(MessagingChain nextMessageHandler) {
		this.nextMessageHandler = nextMessageHandler;
	}
	/* (non-Javadoc)
	 * @see bbLib.MessagingChain#useSkill(java.lang.String)
	 */
	public boolean useSkill(String skill) {
		return nextMessageHandler.useSkill(skill);
	}
}