package bbLib;
/**
 * 
 * Une classe gerant les regles de Blood Bowl classique. Pour iplementer des
 * variantes, il est possible de faire heriter la classe RuleVarint de celle ci
 * afin d'en conserver l'essentiel. <br>
 * 30/05/04 : revision de toutes les fonctions relatives a des passes, ajout
 * d'un gestionnaire de rebonds *
 * 
 * @author Pierre Trocm
 * @version 0.2 - 30 Mai 2004
 *  
 */
public class Rules {
	public final static short QUICK = 4;
	public final static short SHORT = 7;
	public final static short LONG = 11;
	public final static short BOMB = 14;
	public final static short STANDING = 0;
	public final static short ATGROUND = 1;
	public final static short STUNNED = 2;
	public final static short KO = 3;
	public final static short DANDI = 4;
	public final static short HEAT = 0;
	public final static short SUNNY = 1;
	public final static short NICE = 2;
	public final static short RAIN = 3;
	public final static short BLIZZARD = 4;
	/**
	 * Tente d'attrapper la balle au vol. Gere les zones de tacle avecla mthode
	 * <tt>adversairesEnContact()</tt>. Est dsormais thoriquement
	 * compatible avec le skill CATCH.
	 * 
	 * @param accuratePass
	 *            Indique s'il s'agit d'une passe russie ou d'une tentative
	 *            d'attrapper un ballon au sol.
	 * @return <tt>true</tt> si la balle a effectivement t attrappe,
	 *         <tt>false</tt> sinon.
	 */
	public static boolean catchTest(Joueur joueur, boolean accuratePass) {
		return catchTest(joueur, accuratePass, false);
	}
	/**
	 * Tente d'attrapper la balle au sol. Gere les zones de tacle avecla mthode
	 * <tt>adversairesEnContact()</tt>. Est dsormais thoriquement
	 * compatible avec le skill CATCH.
	 * 
	 * @return <tt>true</tt> si la balle a effectivement t attrappe,
	 *         <tt>false</tt> sinon.
	 */
	public static boolean pickUpTest(Joueur joueur) {
		Field field = joueur.getField();
		int pickUpModifier = -field.adversairesEnContact(joueur) + 1;
		if (field.getWeather() == RAIN){
			pickUpModifier--;
		}
		Test pickUpTest;
		if(joueur.has("BIG_HANDS")){
			pickUpTest = new Test(2, 1, pickUpModifier);
		}
		else{
			pickUpTest = new Test(7 - joueur.getAgility(), 1, pickUpModifier);
		}
		if (!test(pickUpTest, "SURE_HANDS", joueur)) {
			return false;
		}
		System.out.println(joueur + " a ramass la balle");
		return true;
	}
	/**
	 * Effectue un weatherRoll.
	 * 
	 * @return Rules.HEAT, Rules.SUNNY, Rules.NICE, Rules.RAIN ou Rules.BLIZZARD
	 */
	public static short weatherRoll() {
		int newWeather = Dices.roll(2);
		switch (newWeather) {
			case 2 :
				return HEAT;
			case 3 :
				return SUNNY;
			case 4 :
//				return NICE;
			case 5 :
//				return NICE;
			case 6 :
//				return NICE;
			case 7 :
//				return NICE;
			case 8 :
//				return NICE;
			case 9 :
//				return NICE;
			case 10 :
				return NICE;
			case 11 :
				return RAIN;
			case 12 :
				return BLIZZARD;
			default :
				System.out.println("Impossible de dterminer le temps");
				return -1;
		}
	}
	/**
	 * Interprete les rsultats d'un test. Une mthode analysant les rsultats
	 * d'un test et effectuant les reRolls d'quipe ou de capacits si
	 * ncssaire. La partie 6rsultat automatique, 1 chec automatique pourrait
	 * etre transfre dans la classe Test, en passant u argument au
	 * contructeur, par exemple.
	 * 
	 * @param test
	 *            Le test  interpreter.
	 * @return <tt>true</tt> le rsultata final du test est un succs,
	 *         <tt>false</tt> sinon.
	 */
	public static boolean test(Test test, String freeReRoll, Joueur joueur) {
		if (test.contains(6)) {
			//Automatic success
			return true;
		}
		if (!test.contains(1) && test.succeded()) {
			//NON automatic fail AND success
			return true;
		}
		//Fail!
		if (joueur.has(freeReRoll) || joueur.askForReRoll()) {
			joueur.usedAReRoll();
			test.reRoll();
			if (test.succeded()) {
				return true;
			}
			System.out.println(" En dpit de l'utilisation de la capacit "
					+ freeReRoll + "Ce test est un chec");
			return true;
		}
		return false;
	}
	/**
	 * Effectue un jet de blesure.
	 * 
	 * @return L'etat dans lequel se trouvera le joueur, Rules.STUNNED, Rules.KO
	 *         ou Rules.DANDI
	 */
	public static short woundRoll() {
		int blessure = Dices.roll(2);
		switch (blessure) {
			case 2 :
				return STUNNED;
			case 3 :
				return STUNNED;
			case 4 :
				return STUNNED;
			case 5 :
				return STUNNED;
			case 6 :
				return STUNNED;
			case 7 :
				return STUNNED;
			case 8 :
				return KO;
			case 9 :
				return KO;
			case 10 :
				return DANDI;
			case 11 :
				return DANDI;
			case 12 :
				return DANDI;
			default :
				System.out
						.println("Impossible de dterminer dans quel tat est"
								+ "Ce joueur"
								+ " - une erreur a eu lieu lors du traitement de la valeur"
								+ blessure);
				return -1;
		}
	}
	/**
	 * Effectue la gestion d'une sequence de blessure complete. Lance les des et
	 * agit en consequence.
	 * 
	 * @param joueur
	 *            Le joueur a blesser
	 * @param field
	 *            Le terrain sur lequel il se trouve
	 */
	public static void wound(Joueur joueur)
	/* throws JoueurInconnuException, IllegalActionException */{
		System.out.println("Un woundRoll va etre lance pour" + joueur);
		Field field = joueur.getField();
		short blessure = woundRoll();
		try {
			switch (blessure) {
				case STUNNED :
					System.out.println(joueur + " est stunned.");
					joueur.setEtat(blessure);
					return;
				case KO :
					if(joueur.has("THICK SKULL") && test(new Test(4, 1), "", joueur) ){
							joueur.setEtat(STUNNED);
							System.out.println(joueur + " est stunned.");
							return;
					}
					System.out.println(joueur + " est KO.");
					joueur.setEtat(blessure);
					field.putInKO(joueur);
					return;
				case DANDI :
					System.out.println(joueur
							+ " est mort ou gravement bless.");
					joueur.setEtat(blessure);
					field.putIndAndI(joueur);
					return;
			}
		}
		//NONE of this exception should happend
		catch (JoueurInconnuException jie) {
			jie.printStackTrace();
		} catch (IllegalActionException e) {
			e.printStackTrace();
		}
	}
	/**
	 * Effectue un jet d'armure et gere ses consquences. Ne fait pour l'instant
	 * aucune diffrence ente le 10, le 11, et le 12 (tous renvoient  dead() )
	 * 
	 * @param modificateur
	 *            le modificateur au jet(notemment dans le cas de
	 *            pietinnements).
	 * @return <tt>true</tt> si le jet est un double, <tt>false</tt> sinon.
	 */
	public static boolean armorRoll(int modificateur, Joueur joueur)
			throws JoueurInconnuException, IllegalActionException {
		Test armorTest = new Test(joueur.getArmor() + 1, 2, modificateur);
		if (!armorTest.succeded())
			return armorTest.isADouble();
		System.out.println("L'armure de " + joueur + "a t passe");
		//		woundRoll();
		Rules.wound(joueur);
		return armorTest.isADouble();
	}
	/**
	 * Fait effectuer  un joueur un jet d'esquive. En cas d'chec, fait tomber
	 * le joueur. Gere, en thorie, la skill DODGE.
	 * 
	 * @return <tt>true</tt> en cas de succs, <tt>false</tt> sinon.
	 */
	public static boolean dodgeTest(Joueur joueur)
			throws IllegalActionException {
		int dodgeModifier = dodgeModifier(joueur);
		if (dodgeModifier == 1)
			return true;
		// System.out.println("Difficult du jet d'esquive " + (7 -
		// agility+dodgeModifier) );
		if(joueur.has("TWO_HEADS")){
			dodgeModifier ++;
		}
		Test dodgeTest = new Test(7 - joueur.getAgility(), 1, dodgeModifier);
		if (test(dodgeTest, "DODGE", joueur))
			return true;
		// System.out.println("Je suis pass par la et je vais tomber!");
		fall(joueur, 0);
		return false;
	}
	/**
	 * Gere la chute d'un joueur. Le met  terre, effectue un jet d'armure.
	 * 
	 * @param ArmorModificator
	 *            le modificateur  appliquer au jet d'armure.
	 */
	public static void fall(Joueur joueur, int armorModificator)
			throws IllegalActionException {
		Field field = joueur.getField();
		joueur.setEtat(ATGROUND);
		if (joueur.hasTheBall()) {
			ballDrop(joueur);
		}
		System.out.println("le joueur " + joueur + " est au sol");
		try {
			armorRoll(0, joueur);
		} catch (JoueurInconnuException e) {
			e.printStackTrace();
		}
	}
	/**
	 * Renseigne sur la difficult du jet d'esquive pour sortir de cette case
	 * 
	 * 
	 * Ne prends pas en compte les capacits spciales, pourrait se faire en
	 * grant un objet Tackledfinition, qui contiendrait diverses infos. Le
	 * constructeur de cet objet contiendrait cette fonction, et serait li a
	 * une classe das les joueurs.
	 * 
	 * @return Le modificateur du jet d'esquive.
	 */
	private static int dodgeModifier(Joueur joueur) {
		Field field = joueur.getField();
		Case c = new Case();
		int d = 1;
		for (int i = -1; i <= 1; i++)
			for (int j = -1; j <= 1; j++) {
				try {
					c = field.getCase(joueur.getX() + i, joueur.getY() + j);
					// System.out.println(c + " va etre testee dans le cadre
					// d'un test de zone de tacle");
					if ((!c.isEmpty())
							&& (c.getOccupant().getTeam() != joueur.getTeam())) {
						d += getTackle(c.getOccupant());
						// System.out.println(c + " a ete testee dans le cadre
						// d'un test de zone de tacle");
					}
				} catch (CaseInexistanteException cie) {
					// System.out.println(cie + " a t considre comme
					// hors-plateau");
				}
			}
		return d;
		//OPTIMISATION : verifier si getZone n'ameliore pas cette methode
	}
	/**
	 * Renvoie l'impacte de la prsence de ce joueur dans une zone de tacle
	 * Devrait par le futur etre remplac par TackleChoseJeSaisPlusTropQuoi.
	 * (voir dodgeDifficulty pour plus d'infos sur cette ide)
	 * 
	 * @return l'impacte d'un tacle, sous forme d'entier
	 */
	public static int getTackle(Joueur joueur) {
		return -1;
	}
	/**
	 * Relve un joueur.
	 * 
	 * @param Le
	 *            joueur a relever.
	 *  
	 */
	public static void getUp(Joueur joueur) throws IllegalActionException {
		short etat = joueur.getEtat();
		if (etat < Rules.ATGROUND)
			throw new IllegalActionException();
		joueur.removeFromMouvementDisponible(3);
		etat = Rules.STANDING;
		System.out.println("Le joueur " + joueur + "n'est plus  terre");
	}
	/**
	 * Sort un joueur de l'tat stunned
	 * 
	 * @param le
	 *            joueur a sortir de l'etat stunned.
	 */
	public static void unStunned(Joueur joueur) {
		joueur.setEtat(ATGROUND);
		System.out.println("Le joueur " + joueur + "n'est plus Stunned");
	}
	
	public static void movePlayer(Joueur joueur, int x, int y) throws IllegalActionException, TouchDownScoredException, CaseInexistanteException{
		movePlayer(joueur, joueur.getField().getCase(x, y));
	}

	/**
	 * Deplace un joueur vers une case donnee
	 * 
	 * @param joueur
	 *            Le joueur a deplacer
	 * @param destination
	 *            La destination ou le mettre
	 * @throws IllegalActionException
	 *             Si le joueur ne peut se deplacer
	 * @throws TouchDownScoredException
	 */
	public static void movePlayer(Joueur joueur, Case destination)
			throws IllegalActionException, TouchDownScoredException {
		if ((joueur.getX() == destination.getX())
				&& (joueur.getY() == destination.getY()))
			return;
		if (joueur.getMouvementDisponible() < 1)
			throw new IllegalActionException();
		//MISE EN FORME : rajouter des trucs dans IllegalActionException
		//OPTIMISATION : un truc qui donne les cases disponibles pour un
		// Mvt
		//Puis simplment verifier que la case choisie en fait partie
		//ou bien garder distance?
		Action action = new Deplacement(joueur, destination);
		action.execute();
	}
	/**
	 * Pousse un joueur d'une case. Attention ! Les deux joueurs doivent etre
	 * sur le meme terrain
	 * 
	 * @param pusher
	 *            Le joueur qui pousse
	 * @param pushed
	 *            Le joueur pouss
	 * @return <tt>true</tt> si le joueur pouss reste sur le terrain,
	 *         <tt>false</tt> sinon.
	 */
	public static boolean push(Joueur pusher, Joueur pushed, boolean followUp,
			MessagingChain pushManager) throws JoueurInconnuException,
			IllegalActionException, CaseNonVideException,
			CaseInexistanteException, TouchDownScoredException {
		Field field = pusher.getField();
		if (field != pushed.getField()) {
			throw new IllegalArgumentException();
		}
		int xModifier, yModifier;
		int nbPossibilites = 3;
		Case origine = new Case(pushed);
		Case median = new Case(2 * pushed.getX() - pusher.getX(), 2
				* pushed.getY() - pusher.getY());
		Case[] possibilites = new Case[3];
		Case[] enTraitement = new Case[3];
		possibilites[0] = median;
		if (pusher.getX() == pushed.getX()) {
			possibilites[1] = new Case(median.getX(), median.getY() - 1);
			possibilites[2] = new Case(median.getX(), median.getY() + 1);
		} else {
			if (pusher.getY() == pushed.getY()) {
				possibilites[1] = new Case(median.getX() - 1, median.getY());
				possibilites[2] = new Case(median.getX() + 1, median.getY());
			} else {
				possibilites[1] = new Case(median.getX()
						+ sign(pushed.getX() - pusher.getX()), median.getY());
				possibilites[2] = new Case(median.getX(), median.getY()
						+ sign(pushed.getY() - pusher.getY()));
			}
		}
		nbPossibilites = 0;
		for (int i = 0; i < 3; i++) {
			//            System.out.println(possibilites[i]);
			try {
				if (field.getCase(possibilites[i]).isEmpty())
					enTraitement[nbPossibilites++] = possibilites[i];
			} catch (CaseInexistanteException cie) {
			}
		}
		if (nbPossibilites == 0) {
			//Bah, va faloir pousser quelqu'un, mon gars
			if (field.isOnTheBorder(pushed)) {
				field.putInReserve(pushed);
				Rules.wound(pushed);
				return false;
			} else {
				Joueur nextPushed;
				int destinationIndex = pushManager.choseASquare(possibilites);
				nextPushed = field.getCase(possibilites[destinationIndex])
						.getOccupant();
				push(pushed, nextPushed, true, pushManager);
				field.placeJoueurAt(pushed, field.getCase(nextPushed));
				if (followUp)
					field.placeJoueurAt(pusher, field.getCase(origine));
				return false;
			}
		}
		int destinationIndex = pushManager.choseASquare(possibilites);
		field.placeJoueurAt(pushed, possibilites[destinationIndex]);
		if (followUp) {
			field.placeJoueurAt(pusher, field.getCase(origine));
		}
		return true;
	}
	/**
	 * Permet de connaitre le signe d'un entier.
	 * 
	 * @param x
	 *            l'entier dont on veut connaitre le signe
	 * @return +1, -1 ou 0
	 */
	protected static int sign(int x) {
		if (x > 0)
			return 1;
		if (x == 0)
			return 0;
		return -1;
	}
	/**
	 * Effectue une passe. Pour l'instant le test de passe prend en compte comme
	 * modificateur de zones de tacle le rsultat de la mthode
	 * <tt>adversairesEnContact()</tt> -1. Prends en compte les skill PASS et ACCURATE.
	 * 
	 * @param destination
	 *            L'endroit ou sera envoy la balle
	 * @return <code>1</code> si le test est un succes, <code>-1</code> en
	 *         cas de fumble, <code>0</code> sinon.
	 */
	public static int passTest(Joueur joueur, Positionable destination)
			throws IllegalActionException {
		Team team = joueur.getTeam();
		Field field = joueur.getField();
		if (!joueur.hasTheBall())
			throw new IllegalActionException();
		int passModifier = 1;//Quick Pass
		if (Field.distance(joueur, destination) > QUICK)
			passModifier = 0;//Short Pass
		if (Field.distance(joueur, destination) > SHORT) {//Long Pass
			if (field.getWeather() == BLIZZARD) {
				throw new IllegalActionException();
			}
			passModifier = -1;
		}
		if (Field.distance(joueur, destination) > LONG)
			passModifier = -2;
		if (Field.distance(joueur, destination) > BOMB) {
			throw new IllegalActionException();
		}
		if (field.getWeather() == SUNNY)
			passModifier--;
		if(!joueur.has("NERVES_OF_STEELS")){
			passModifier -= field.adversairesEnContact(joueur);
		}
		if(joueur.has("ACCURATE")){
			passModifier++;
		}
		Test passTest = new Test(7 - joueur.getAgility(), 1, passModifier);
		if (test(passTest, "PASS", joueur)) {
			System.out.println(joueur + " a reussi une passe");
			return 1;
		}
		if (passTest.containsLessThanOne()) {
			//fumble
			System.out.println(joueur
					+ " a fait un fumble en tentant une passe");
			field.ballBounce();
			joueur.turnOverHappened();
			return -1;
		}
		System.out.println(joueur + " a rate une passe");
		return 0;
	}
	/**
	 * Effectue un mouvement de Sprint.
	 * 
	 * @param destination
	 */
	public static void sprint(Joueur joueur, Case destination)
			throws IllegalActionException, TouchDownScoredException {
		if (joueur.getAvailableSprintSquare() < 1) {
			throw new IllegalActionException();
		}
		Field field = joueur.getField();
		int sprintDifficulty;
		movePlayer(joueur, destination);
		joueur.addUsedSprintSquare();
		sprintDifficulty = (field.getWeather() == BLIZZARD) ? 3 : 2;
		Test test = new Test(sprintDifficulty, 1);
		if (!test(test, "SURE_FEETS", joueur)) {
			fall(joueur, 0);
		}
	}
	/**
	 * Initie un blocage ou un pietinement sur une cible. Tant qu'il sera
	 * debout, le joueur frappera une fois par tour sa cible.
	 * 
	 * @param cible
	 *            Le joueur dsign comme cible du blocage.
	 */
	public static void attack(Joueur agresseur, Joueur cible)
			throws IllegalActionException, TouchDownScoredException {
		Action action;
		Field field = agresseur.getField();
		if (Field.distance(agresseur, cible) >= 2){
			System.out.println("Les deux joueurs sont trop loin pour se battre. Distance = " + Field.distance(agresseur, cible));
			throw new IllegalActionException();
		}
		if (cible.getTeam() == agresseur.getTeam())
			throw new IllegalActionException();
		if (!field.exist(cible))
			throw new IllegalActionException();
		if (cible.isStanding()) {
			System.out
					.println(agresseur + " va tenter un blocage sur " + cible);
			action = new Blocage(agresseur, cible);
		} else {
			System.out.println(agresseur + " va tenter de pietinner " + cible);
			action = new Pietinement(agresseur, cible);
		}
		action.execute();
	}
	/**
	 * Deplace la balle d'un joueur a un joueur adjacent.
	 * 
	 * @param joueur
	 *            Le joueur supos passer la balle
	 * @param destination
	 *            Lendroit ou envoyer la balle
	 * @throws IllegalActionException
	 *             Si les regles n'autorisent pas sette action
	 */
	public static void handOff(Joueur joueur, Positionable destination)
			throws IllegalActionException, CaseInexistanteException {
		if (Field.distance(joueur, destination) >= 2)
			throw new IllegalActionException();
		if (!joueur.hasTheBall())
			throw new IllegalActionException();
		Field field = joueur.getField();
		if (catchTest(field.getCase(destination).getOccupant(), true)) {
			field.placeBallAt(destination);
			return;
		} else {
			ballDrop(joueur);
		}
	}
	/**
	 * Une fonction gerant de maniere avance les rebonds. La balle rebondira
	 * tant que personne ne l'attrappe, ou qu'elle n'arrive sur une case vide.
	 * 
	 * @return <tt>true</tt> si la balle a t attrappe, <tt>false</tt> si
	 *         elle s'est arrte sur une case vide.
	 */
	public static boolean ballBounceUntilStopped(Field field) {
		try {
			field.ballBounce();
			System.out.println("la balle a rebondi en "
					+ field.getBallPosition());
			while (!field.getCase(field.getBallPosition()).isEmpty()) {
				if (field.getCase(field.getBallPosition()).getOccupant()
						.isStanding())
					if (Rules.pickUpTest(field.getCase(field.getBallPosition())
							.getOccupant())) {
						System.out.println(field.getBallPosition()
								+ " a ramass la balle.");
						return true;
					}
				field.ballBounce();
			}
			System.out
					.println("Apres rebondissements, la balle est arrive en "
							+ field.getBallPosition());
			return false;
		} catch (CaseInexistanteException cie) {
			System.out
					.println("Impossible de lacher la balle, son emplacement n'est pas valable");
		}
		return false;
	}
	/**
	 * Gere une passe complete. Fait arriver un turnOver en cas de fumble.
	 * 
	 * @param joueur
	 *            Le joueur lancant la balle.
	 * @param destination
	 *            La destination de son envoi.
	 * @return <code>true</code> si a a fin de la passe le joueur en
	 *         possession de la balle appatient a la meme equipe que le lanceur.
	 *         <code>false</code> sinon.
	 * @throws IllegalActionException
	 * @throws CaseInexistanteException
	 */
	public static boolean pass(Joueur joueur, Positionable destination)
			throws IllegalActionException, CaseInexistanteException {
		Field field = joueur.getField();
		Case ballCase;
		Joueur tmpJoueur;
		tmpJoueur = ballHasBeenIntercepted(joueur, destination);
		if (tmpJoueur != null) {
			tmpJoueur.interceptedTheBall();
			field.placeBallAt(tmpJoueur);
			return false;
		}
		switch (passTest(joueur, destination)) {
			case -1 :
				ballDrop(joueur);
				joueur.turnOverHappened();
				return false;
			case 0 :
				field.placeBallAt(destination);
				for (int i = 0; i < 2; i++) {
					field.ballBounce();
				}
				if (ballBounceUntilStopped(field)) {
					return field.getCase(field.getBallPosition()).getOccupant()
							.getTeam() == joueur.getTeam();
				} else {
					return false;
				}
			case 1 :
				if (field.placeBallAt(destination)) {
					ballCase = field.getCase(field.getBallPosition());
					if (catchTest(ballCase.getOccupant(), true)) {
						return field.getCase(field.getBallPosition())
								.getOccupant().getTeam() == joueur.getTeam();
					} else {
						if (ballDrop(ballCase.getOccupant())) {
							return field.getCase(field.getBallPosition())
									.getOccupant().getTeam() == joueur
									.getTeam();
						} else {
							return false;
						}
					}
				} else {
					return false;
				}
			default :
				return false;//Ne devrait jamais arriver
		}
	}
	/**
	 * Gere le lacher de balle par un joueur. Se comporte comme
	 * ballBounceUntilStopped
	 * 
	 * @param joueur
	 *            Le joueur lachant la balle
	 * @return <tt>true</tt> si la balle a t attrappe, <tt>false</tt> si
	 *         elle s'est arete sur une case vide.
	 * @throws IllegalActionException
	 *             Si le joueur ne possede pas la balle.
	 */
	public static boolean ballDrop(Joueur joueur)
			throws IllegalActionException {
		if (!joueur.hasTheBall()) {
			throw new IllegalActionException();
		}
		System.out.println(joueur + " a lach la balle");
		return ballBounceUntilStopped(joueur.getField());
	}
	/**
	 * Tente d'attrapper la balle au vol. Gere les zones de tacle avecla mthode
	 * <tt>adversairesEnContact()</tt>. Est dsormais thoriquement
	 * compatible avec le skill CATCH.
	 * 
	 * @param isAnInterception
	 *            Indique s'il s'agit d'une interception
	 * @param accuratePass
	 *            Indique s'il s'agit d'une passe russie ou d'une tentative
	 *            d'attrapper un ballon au sol.
	 * @return <tt>true</tt> si la balle a effectivement t attrappe,
	 *         <tt>false</tt> sinon.
	 */
	public static boolean catchTest(Joueur joueur, boolean accuratePass,
			boolean isAnInterception) {
		Field field = joueur.getField();
		int catchModifier = 0;
		if(!joueur.has("NERVES_OF_STEELS")){
			catchModifier -= field.adversairesEnContact(joueur);
		}
		if(!isAnInterception && joueur.has("EXTRA ARM")){
			catchModifier ++;
		}
		if (accuratePass)
			catchModifier++;
		if (isAnInterception)
			catchModifier -= 2;
		if (field.getWeather() == RAIN)
			catchModifier--;
		Test catchTest = new Test(7 - joueur.getAgility(), 1, catchModifier);
		if (!test(catchTest, "CATCH", joueur)) {
			return false;
		}
		System.out.println(joueur + " a attrapp la balle");
		try {
			joueur.getField().placeBallAt(joueur.getX(), joueur.getY());
		} catch (CaseInexistanteException e) {
			//Ne devrait jamais arriver
			e.printStackTrace();
		}
		return true;
	}
	/**
	 * Tente d'intercepter la balle au vol. Gere les zones de tacle avecla
	 * mthode <tt>adversairesEnContact()</tt>. Est dsormais thoriquement
	 * compatible avec le skill CATCH.
	 * 
	 * @return <tt>true</tt> si la balle a effectivement t attrappe,
	 *         <tt>false</tt> sinon.
	 */
	public static boolean interceptionTest(Joueur joueur) {
		return catchTest(joueur, false, true);
	}
	protected static Joueur ballHasBeenIntercepted(Joueur thrower,
			Positionable destination) {
		Joueur[] candidats = new Joueur[32];
		int nbCandidats = 0;
		int chosenCandidat;
		Field field = thrower.getField();
		Case tmpCase;
		if (thrower.getX() == destination.getX()) {
			//X = Cste
			for (int x = thrower.getX() - 1; x <= thrower.getX() + 1; x++) {
				for (int y = Math.min(thrower.getY(), destination.getY()) + 1; y < Math
						.max(thrower.getY(), destination.getY()); y++) {
					try {
						tmpCase = field.getCase(x, y);
						if (tmpCase.isEmpty()) {
							continue;
						}
						if (tmpCase.getOccupant().getTeam() != thrower
								.getTeam()) {
							candidats[nbCandidats++] = tmpCase.getOccupant();
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		} else {
			//Y = ax + b
			double a, b;
			a = (destination.getY() - thrower.getY())
					/ (destination.getX() - thrower.getX());
			b = thrower.getY() - a * thrower.getX();
			for (double c = b - 1; c <= b + 1; c++) {
				for (int i = Math.min(thrower.getX(), destination.getX()); i < Math
						.max(thrower.getX(), destination.getX()); i++) {
					try {
						tmpCase = field.getCase(i, (int) Math.floor(a * i + c));
						if (!tmpCase.isEmpty()) {
							if (tmpCase.getOccupant().getTeam() != thrower
									.getTeam()) {
								candidats[nbCandidats++] = tmpCase
										.getOccupant();
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
		if (nbCandidats != 0) {
			Joueur[] toSend = new Joueur[nbCandidats];
			for (int i = 0; i < nbCandidats; i++) {
				toSend[i] = candidats[i];
			}
			chosenCandidat = candidats[0].askForInterception(toSend);
		} else {
			System.out.println("Personne ne peut tenter d'interception");
			return null;
		}
		if (chosenCandidat == -1) {
			System.out.println("aucune interception tente");
			return null;
		}
		if (interceptionTest(candidats[chosenCandidat])) {
			System.out.println(candidats[chosenCandidat]
					+ " a russi une interception");
			return candidats[chosenCandidat];
		} else {
			System.out.println(candidats[chosenCandidat]
					+ " a echoue dans sa tentative d'interception");
			return null;
		}
	}
	/**
	 * @param joueur Le joueur qui souhiqte sprinter
	 * @param x	L'abcisse de la case de destination
	 * @param y	L'ordonne de la case de destination
	 */
	public static void sprint(Joueur joueur, int x, int y) throws IllegalActionException, TouchDownScoredException, CaseInexistanteException {
		sprint(joueur, joueur.getField().getCase(x, y));		
	}
}