package bbLib;
import java.util.Iterator;
import java.util.Observable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.FileInputStream;

/**
 * Une classe servant  contruire une quipe jouable.
 * 
 * @author Pierre Trocm
 * @version 0.3 - 11 fvrier 2004
 */
public class TeamBuilder extends Observable
{
	private TeamReferenceSheet teamReferenceSheet;
    private VectorSet roster;
    private int reRolls, fanFactor, cheerleaders, assistantCoach, apothecaries, wizards;
    private int treaseaury;
//	Tout ca pourrait passer avec un obet RuleSet
    private static final int BUDGET = 1000;
    private static final int NBMAX = 15;
    //des variables qui dpendront plus tard de la variante  laquelle on joue
	private final static int FANFACTORPRICE = 10;
	private final static int WIZARDPRICE = 50;
	private final static int CHEERLEADERSPRICE = 10;
	private final static int APOTHECARYPRICE = 50;
	private final static int ASSISTANTPRICE = 10;
	private GameVariant gameVariant;
    
    /**
     * Constructor for objects of class TeamBuilder
     */
    public TeamBuilder(String teamReferenceSheetName, GameVariant gameVariant)
    {
    	this.gameVariant = gameVariant;
        teamReferenceSheet = readTeamReferenceSheet(teamReferenceSheetName);
        roster = new VectorSet(NBMAX);
    }
    
    /**
     * Constructor for objects of class TeamBuilder
     */
    public TeamBuilder(TeamReferenceSheet teamReferenceSheet, GameVariant gameVariant)
    {
    	this.gameVariant = gameVariant;
        this.teamReferenceSheet = teamReferenceSheet;
        roster = new VectorSet(NBMAX);
        treaseaury = BUDGET;
    }
    
    public Roster getTeam(String name, String coachName, VectorSet playerNames){
        int nbRerollsEffectifs = reRolls;
//        if(teamReferenceSheet.hasFreeReRoll()) nbRerollsEffectifs++;//Je crois que les free re-Rolls n'existent plus...
        Roster retour = new Roster(name, coachName, nbRerollsEffectifs, fanFactor, cheerleaders, assistantCoach, apothecaries, wizards, treaseaury, teamReferenceSheet.getReRollCost(), gameVariant);
        for(int i = 0; i<NBMAX; i++) if (roster.elementAt(i) != null) retour.addJoueur(new Joueur( (RacineJoueur)roster.elementAt(i), (String)playerNames.elementAt(i)), i+1);
        return retour;
    }
    
    public static void writeTeam(Roster Roster){
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(Roster.getName() + ".team"));
            oos.writeObject(Roster);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {oos.flush();} 
                  catch (IOException ioe) {}
                try {oos.close();} 
                  catch (IOException ioe) {}
            }
        }
    }
    
    public static Roster readTeam(String name){
        Roster Roster = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(name + ".team"));
            Roster = (Roster)ois.readObject();
//            System.out.println("Read object " + o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {ois.close();} 
                 catch (IOException ioe) {}
            }
        }
        return Roster;
    }
    
    
    public static void writeTeam(TeamReferenceSheet teamRS){
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(teamRS.getRace() + ".ref"));
            oos.writeObject(teamRS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {oos.flush();} 
                  catch (IOException ioe) {}
                try {oos.close();} 
                  catch (IOException ioe) {}
            }
        }
    }
    
//	public static TeamReferenceSheet readTeamReferenceSheet(String name){
//		TeamReferenceSheet teamRS = null;
//		ObjectInputStream ois = null;
//		try {
//			ois = new ObjectInputStream(new FileInputStream(name + ".ref"));
//			teamRS = (TeamReferenceSheet)ois.readObject();
////			  System.out.println("Read object " + o);
//		}
//		catch (Exception e) {
//			e.printStackTrace();
//		}
//		finally {
//			if (ois != null) {
//				try {ois.close();} 
//				 catch (IOException ioe) {}
//			}
//		}
//		return teamRS;
//	}


	public static TeamReferenceSheet readTeamReferenceSheet(String name){
		try {
			return readTeamReferenceSheet(new FileInputStream(name + ".ref"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}

    
	public static TeamReferenceSheet readTeamReferenceSheet(File file){
		try {
			return readTeamReferenceSheet(new FileInputStream(file));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}
    
    
	public static TeamReferenceSheet readTeamReferenceSheet(FileInputStream fileInputStream){
		TeamReferenceSheet teamRS = null;
		ObjectInputStream ois = null;
		try {
			ois = new ObjectInputStream(fileInputStream);
			teamRS = (TeamReferenceSheet)ois.readObject();
//			  System.out.println("Read object " + o);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			if (ois != null) {
				try {ois.close();} 
				 catch (IOException ioe) {}
			}
		}
		return teamRS;
	}

    public int evaluate(){
        int sum = 0;
        RacineJoueur next;
        Iterator iterator = roster.iterator();
        while(iterator.hasNext()) {
            next = (RacineJoueur)iterator.next();
            if (next != null) sum += next.getPrix();
        }
        sum += reRolls * teamReferenceSheet.getReRollCost();
        sum += fanFactor * 10 + cheerleaders * 10 + assistantCoach * 10;
        return sum;
    }
    
    public boolean addJoueur(int index, int numero){
        RacineJoueur joueurToAdd = teamReferenceSheet.getRacineJoueurAt(index);
        if(evaluate() + joueurToAdd.getPrix() > BUDGET) return false;//On pourrait thrower une exception
        if(!joueurToAdd.oneMoreInRoster()) return false;//On pourrait thrower une exception
        roster.add(numero-1, joueurToAdd);
        return true;
    }
    
    public boolean addReRoll(){
        if(evaluate() + teamReferenceSheet.getReRollCost() > BUDGET) return false;//On pourrait thrower une exception
        reRolls++;
        return true;
    }

    public void removeReRoll(){
        reRolls--;
    }
    
    public void removeJoueur(int numero){
        RacineJoueur joueurToRemove = (RacineJoueur)roster.remove(numero);
        joueurToRemove.oneLessInRoster();        
    }

    
    public static void writeHtmlRoster(Roster roster) throws IOException{
    	Joueur tmpJoueur;
    	String htmlName = roster + ".html";
		FileWriter fileWriter = new FileWriter(htmlName);
		
		fileWriter.write("<HTML><HEAD><TITLE>" + roster.getName() + "</TITLE></HEAD>");
		fileWriter.write("<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#000000\" VLINK=\"#000000\">");
		fileWriter.write("<CENTER><FONT FACE=\"MS Sans Serif\" SIZE=4 COLOR=\"#000000\">");
		fileWriter.write("<H1><B>" + roster.getName() + "</B></H1>");
		fileWriter.write("Race: " + roster.getRace() + "<BR>");
		fileWriter.write("Coached By: " + roster.getCoachName()+"<BR></FONT>");
		fileWriter.write("<TABLE BORDER=1 BGCOLOR=\"#FFFFD0\" BORDERCOLORLIGHT=\"#FFFFF0\" BORDERCOLORDARK=\"#BFBF90\">");
		fileWriter.write("<FONT FACE=\"MS Sans Serif\">");
		fileWriter.write("<TR BGCOLOR=\"#D0D0A0\"><TH>#</TH><TH>Player Name</TH><TH>Position</TH><TH>ma</TH><TH>st</TH><TH>ag</TH><TH>av</TH><TH>Player Skills</TH><TH>ij</TH><TH>cp</TH><TH>td</TH><TH>in</TH><TH>cs</TH><TH>vp</TH><TH>sp</TH><TH>Cost</TH></TR>");
		for(int i = 0; i < roster.getNBMAX(); i++) {
			tmpJoueur = roster.getJoueur(i);
			fileWriter.write("<TR ALIGN=CENTER><TD>" + i + "</TD><TD ALIGN=LEFT>" + tmpJoueur.getName() + "</TD><TD ALIGN=LEFT>Wight</TD><TD>");
			fileWriter.write(tmpJoueur.getMovement() + "</TD><TD>" + tmpJoueur.getStrenght()+"</TD><TD>" + tmpJoueur.getAgility() + "</TD><TD>" + tmpJoueur.getArmor() +"</TD><TD ALIGN=LEFT>");
			fileWriter.write(tmpJoueur.getCapacities().toString());
			fileWriter.write("</TD><TD>&nbsp</TD><TD>&nbsp</TD><TD>&nbsp</TD><TD>&nbsp</TD><TD>&nbsp</TD><TD>&nbsp</TD><TD>&nbsp</TD><TD ALIGN=RIGHT>");
			fileWriter.write(tmpJoueur.getPrix() + "</TD></TR>");
		}    
		fileWriter.write("<TR><TD></TD></TR><TR><TD></TD></TR>");
		fileWriter.write("<TR ALIGN=CENTER><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Team Name: </TD><TD COLSPAN=5>" + roster.getName());
		fileWriter.write("</TD><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Re-Rolls: </TD><TD COLSPAN=2>" + roster.getReRolls());
		fileWriter.write("</TD><TD BGCOLOR=\"#D0D0A0\" COLSPAN=4>x $" + roster.getReRollCost() + "k = </TD><TD ALIGN=RIGHT>");
		fileWriter.write(roster.getReRollCost() * roster.getReRolls() + "</TD></TR>");
		
		fileWriter.write("<TR ALIGN=CENTER><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Race: </TD><TD COLSPAN=5>" + roster.getRace());
		fileWriter.write("</TD><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Fan Factor: </TD><TD COLSPAN=2>" + roster.getFanFactor());
		fileWriter.write("</TD><TD BGCOLOR=\"#D0D0A0\" COLSPAN=4>x $" + FANFACTORPRICE + "k =</TD><TD ALIGN=RIGHT>" + FANFACTORPRICE * roster.getFanFactor() + "</TD></TR>");
		
		fileWriter.write("<TR ALIGN=CENTER><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Team Rating: </TD><TD COLSPAN=5>" + roster.getRating());
		fileWriter.write("</TD><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Assistant Coaches: </TD><TD COLSPAN=2>" + roster.getAssistantCoach());
		fileWriter.write("</TD><TD BGCOLOR=\"#D0D0A0\" COLSPAN=4>x $" + ASSISTANTPRICE + "k =</TD><TD ALIGN=RIGHT>" + ASSISTANTPRICE * roster.getAssistantCoach() +"</TD></TR>");
		
		fileWriter.write("<TR ALIGN=CENTER><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Treaseaury: </TD><TD COLSPAN=5>" + roster.getTreaseaury());
		fileWriter.write("</TD><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Cheerleaders: </TD><TD COLSPAN=2>" + roster.getCheerleaders());
		fileWriter.write("</TD><TD BGCOLOR=\"#D0D0A0\" COLSPAN=4>x $" + CHEERLEADERSPRICE + "k =</TD><TD ALIGN=RIGHT>" + CHEERLEADERSPRICE * roster.getCheerleaders()+"</TD></TR>");
		
		fileWriter.write("<TR ALIGN=CENTER><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Coach: </TD><TD COLSPAN=5>" + roster.getCoachName());
		fileWriter.write("</TD><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Apothecary: </TD><TD COLSPAN=2>" + roster.getApothecaries());
		fileWriter.write("</TD><TD BGCOLOR=\"#D0D0A0\" COLSPAN=4>x $" + APOTHECARYPRICE + "k =</TD><TD ALIGN=RIGHT>" + APOTHECARYPRICE * roster.getApothecaries() + "</TD></TR>");
		
		fileWriter.write("<TR ALIGN=CENTER><TD COLSPAN=7 ROWSPAN=2>&nbsp</TD><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=2>Team Wizard:</TD><TD COLSPAN=2> " + roster.getWizards() + "</TD><TD BGCOLOR=\"#D0D0A0\" COLSPAN=4>x $" + WIZARDPRICE + "k =</TD><TD ALIGN=RIGHT>" + roster.getWizards() * WIZARDPRICE + "</TD></TR>");
		fileWriter.write("<TR ALIGN=CENTER><TD ALIGN=RIGHT BGCOLOR=\"#D0D0A0\" COLSPAN=8>TOTAL COST OF TEAM:</TD><TD ALIGN=RIGHT>1000000</TD></TR></TABLE><CENTER><FONT FACE=\"MS Sans Serif\" SIZE=4 COLOR=\"#000000\"><P><P>Match Record<P></FONT><TABLE BORDER=1 BGCOLOR=\"#FFFFD0\" BORDERCOLORLIGHT=\"#FFFFF0\" BORDERCOLORDARK=\"#BFBF90\"><FONT FACE=\"MS Sans Serif\"><TR BGCOLOR=\"#D0D0A0\" ALIGN=CENTER><TH>Result</TH><TH>Opponent</TH><TH>Race</TH><TH>Score</TH><TH>Cas</TH><TH>Gate</TH><TH>Winnings</TH><TH>Notes & Highlights</TH></TR></TABLE></BODY></HTML>");
		//BUILDER: un lecteur de pages HTML contenqnt une quipe
    }
    
	/**
	 * @return
	 */
	public int getApothecaries() {
		return apothecaries;
	}

	/**
	 * @return
	 */
	public int getAssistantCoach() {
		return assistantCoach;
	}

	/**
	 * @return
	 */
	public int getCheerleaders() {
		return cheerleaders;
	}

	/**
	 * @return
	 */
	public int getFanFactor() {
		return fanFactor;
	}

	/**
	 * @return
	 */
	public int getReRolls() {
		return reRolls;
	}

	/**
	 * @return
	 */
	public int getTreaseaury() {
		return treaseaury;
	}

	/**
	 * @param i
	 */
	public void setApothecaries(int i) {
		treaseaury  -=  (i - apothecaries) * APOTHECARYPRICE; 
		apothecaries = i;
		notifyObservers();
	}

	/**
	 * @param i
	 */
	public void setAssistantCoach(int i) {
		treaseaury -= (i - assistantCoach) * ASSISTANTPRICE;
		assistantCoach = i;
		notifyObservers();
	}

	/**
	 * @param i
	 */
	public void setCheerleaders(int i) {
		treaseaury -= (i - cheerleaders) * CHEERLEADERSPRICE;
		cheerleaders = i;
		notifyObservers();
	}

	/**
	 * @param i
	 */
	public void setFanFactor(int i) {
		treaseaury -= (i - fanFactor) * FANFACTORPRICE;
		fanFactor = i;
		notifyObservers();
	}

	/**
	 * @param i
	 */
	public void setReRolls(int i) {
		treaseaury -= (i - reRolls) * teamReferenceSheet.getReRollCost();		
		reRolls = i;
		notifyObservers();
	}

	/**
	 * @return
	 */
	public int getWizards() {
		return wizards;
	}

	/**
	 * @param i
	 */
	public void setWizards(int i) {
		treaseaury -= (i - wizards) * WIZARDPRICE;		
		wizards = i;
		notifyObservers();		
	}

}
