package bbLib;
import java.util.Iterator;
import java.util.Vector;
import java.io.Serializable;
import java.util.Enumeration;

/**
 * Une classe dcrivant une feuille de rfrence d'une quipe
 * 8 Septembre 2004 : ajout d'un SerialVersionUID, compaptibilit avec java 1.5
 * @author Pierre Trocm
 * @version 0.2 - 12 fvrier 2004
 */

public class TeamReferenceSheet implements Serializable
{
    private static final long serialVersionUID = -816809369897418920L;
	private Vector<RacineJoueur> joueurs;
    private String race;
    private int reRollCost;
    
    
    /**
     * Constructor for objects of class TeamReferenceSheet
     */
    public TeamReferenceSheet(String race, int reRollCost){
        this.race = race;
        this.reRollCost = reRollCost;
        joueurs = new Vector<RacineJoueur>();
    }
   
    public void addRacineJoueur(RacineJoueur joueur){
        if(!joueurs.contains(joueur)) joueurs.add(joueur);
    }
    
    public void removeRacineJoueur(RacineJoueur joueur){
        joueurs.remove(joueur);
    }
    
    public String toString(){
        Enumeration enumeration = joueurs.elements();
        String retour = new String();
        retour +="Feuille de reference de l'equipe " + race + '\n';
        while(enumeration.hasMoreElements()) retour += enumeration.nextElement().toString() + '\n';
        return retour;
    }
    
    public RacineJoueur getRacineJoueurAt(int index){
        return (RacineJoueur)joueurs.elementAt(index);
    }
    
    public Iterator iterator(){
    	return joueurs.iterator();
    }
    
    public int getReRollCost(){
        return reRollCost;
    }
    
    public String getRace(){
        return race;
    }
}
