/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.nyp.drmPublisher.samples;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import sg.edu.nyp.drmPublisher.DDFile;
import sg.edu.nyp.drmPublisher.DMFile;
import sg.edu.nyp.drmPublisher.MIMEType;
import sg.edu.nyp.drmPublisher.MMSFile;
import sg.edu.nyp.drmPublisher.NonMMSAddressException;

public class VisualPublisher
extends JPanel {
    private JTextField objectURITxt;
    private JTextField destinationChooserTxt;
    private JTextField mmsFileNameTxt;
    private JTextField subjectTxt;
    private JTextField transactionIdTxt;
    private JTextField bccTxt;
    private JTextField ccTxt;
    private JTextField toTxt;
    private JTextField fromTxt;
    private JTextField vendorTxt;
    private JTextField installParamsTxt;
    private JTextField infoURLTxt;
    private JTextField iconURLTxt;
    private JTextField nextURLTxt;
    private JTextField installNotifyURLTxt;
    private JTextField descriptionTxt;
    private JTextField nameTxt;
    private JTextField boundaryStringTxt;
    private JCheckBox downloadDescriptorCB;
    private JCheckBox forwardLockCB;
    private JCheckBox mmsSendingCB;
    private JCheckBox mmsGenerationCB;
    private JTextField fileChooserTxt;
    private JRadioButton binaryButton;
    private JTextField prefixTxt;
    private JLabel prefixPreviewMsg;
    static /* synthetic */ Class class$0;

    public VisualPublisher() {
        super(new GridLayout(1, 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        ImageIcon icon = VisualPublisher.createImageIcon("images/middle.gif");
        JComponent mainPanel = this.makeMainPanel();
        tabbedPane.addTab("General Options", icon, mainPanel, "Click Here for setting up general options");
        tabbedPane.setMnemonicAt(0, 49);
        JComponent DRMPanel = this.makeDRMPanel();
        tabbedPane.addTab("OMA DRM options", icon, DRMPanel, "Click Here for the Forward Lock options");
        tabbedPane.setMnemonicAt(1, 50);
        JComponent MMSPanel = this.makeMMSPanel();
        MMSPanel.setPreferredSize(new Dimension(410, 50));
        tabbedPane.addTab("MMS Options", icon, MMSPanel, "Click here for the Multimedia Messenging Service Options");
        tabbedPane.setMnemonicAt(2, 51);
        this.add(tabbedPane);
        tabbedPane.setTabLayoutPolicy(1);
    }

    private JComponent makeMMSPanel() {
        JPanel panel = new JPanel(false);
        panel.setLayout(new GridLayout(0, 1));
        JPanel introPanel = new JPanel();
        JLabel filler = new JLabel("Multimedia Messenging (MMS) Options");
        filler.setHorizontalAlignment(0);
        JButton addressHelpButton = new JButton("?");
        addressHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "The from, and at least one of the to/cc/bcc address are mandatory. \n They can be either email address or phone numbers starting with the + country indicator character \nExamples: me@home.net, +65 456 892", "Help: MMS addressing", 1, null);
            }
        });
        addressHelpButton.setAlignmentY(1.0f);
        introPanel.add(filler);
        introPanel.add(addressHelpButton);
        panel.add(introPanel);
        JLabel fromLabel = new JLabel("From: ");
        this.fromTxt = new JTextField(35);
        JPanel fromPanel = new JPanel();
        JLabel fromStar = new JLabel("*");
        fromPanel.add(fromLabel);
        fromPanel.add(this.fromTxt);
        fromPanel.add(fromStar);
        panel.add(fromPanel);
        JLabel toLabel = new JLabel("To: ");
        this.toTxt = new JTextField(35);
        JLabel toStar = new JLabel("*");
        JPanel toPanel = new JPanel();
        toPanel.add(toLabel);
        toPanel.add(this.toTxt);
        toPanel.add(toStar);
        panel.add(toPanel);
        JLabel ccLabel = new JLabel("Cc: ");
        this.ccTxt = new JTextField(35);
        JLabel ccStar = new JLabel("*");
        JPanel ccPanel = new JPanel();
        ccPanel.add(ccLabel);
        ccPanel.add(this.ccTxt);
        ccPanel.add(ccStar);
        panel.add(ccPanel);
        JLabel bccLabel = new JLabel("Bcc: ");
        this.bccTxt = new JTextField(35);
        JLabel bccStar = new JLabel("*");
        JPanel bccPanel = new JPanel();
        bccPanel.add(bccLabel);
        bccPanel.add(this.bccTxt);
        bccPanel.add(bccStar);
        panel.add(bccPanel);
        JLabel mmsFileNameLabel = new JLabel("MMS file name: ");
        JLabel mmsExtensionLabel = new JLabel(".mms");
        JLabel mmsFileName2Label = new JLabel("If let empty, the name will be set to file_to_publish.mms");
        this.mmsFileNameTxt = new JTextField(35);
        JPanel mmsFileNamePanel = new JPanel();
        mmsFileNamePanel.add(mmsFileNameLabel);
        mmsFileNamePanel.add(this.mmsFileNameTxt);
        mmsFileNamePanel.add(mmsExtensionLabel);
        panel.add(mmsFileNamePanel);
        panel.add(mmsFileName2Label);
        JLabel subjectLabel = new JLabel("Subject: ");
        this.subjectTxt = new JTextField(35);
        JPanel subjectPanel = new JPanel();
        subjectPanel.add(subjectLabel);
        subjectPanel.add(this.subjectTxt);
        panel.add(subjectPanel);
        JLabel transactionIdLabel = new JLabel("Transaction ID: ");
        this.transactionIdTxt = new JTextField("1234567890", 35);
        JButton transactioIdHelpButton = new JButton("?");
        transactioIdHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "The transaction ID will be used by the MMSC to identify a direct reply to this MMS. \nIt can be any alpha numerical String.", "Help: MMS Transaction Id", 1, null);
            }
        });
        JPanel transactionIdPanel = new JPanel();
        transactionIdPanel.add(transactionIdLabel);
        transactionIdPanel.add(this.transactionIdTxt);
        transactionIdPanel.add(transactioIdHelpButton);
        panel.add(transactionIdPanel);
        JLabel mandatory = new JLabel("*: The from parameters and at least one of -to/-cc/-bcc are mandatory.");
        panel.add(mandatory);
        return panel;
    }

    private JComponent makeDRMPanel() {
        JPanel panel = new JPanel(false);
        JLabel warningLabel = new JLabel("Warning : the dd and dm file will be generated only if requested on the General Options tab");
        panel.setLayout(new GridLayout(0, 1));
        JSeparator separator = new JSeparator();
        this.addDMPanel(panel);
        panel.add(separator);
        this.addDDPanel(panel);
        panel.add(warningLabel);
        return panel;
    }

    private void addDDPanel(JPanel panel) {
        JLabel ddLabel = new JLabel("Download descriptor (.dd) file options: ");
        panel.add(ddLabel);
        JLabel objectURILabel = new JLabel("Object URI: ");
        JLabel objectURIWLabel = new JLabel("Fill this field only if the publishing location is different from the current location");
        this.objectURITxt = new JTextField(35);
        JPanel objectURIPanel = new JPanel();
        objectURIPanel.add(objectURILabel);
        objectURIPanel.add(this.objectURITxt);
        panel.add(objectURIPanel);
        objectURIWLabel.setHorizontalAlignment(0);
        panel.add(objectURIWLabel);
        JLabel nameLabel = new JLabel("Name: ");
        this.nameTxt = new JTextField(35);
        JButton nameHelpButton = new JButton("?");
        nameHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "The name of the published content as it will appear to the recipient when receiving the download descriptor.", "DD file generation help: setting the name", 1, null);
            }
        });
        JPanel namePanel = new JPanel();
        namePanel.add(nameLabel);
        namePanel.add(this.nameTxt);
        namePanel.add(nameHelpButton);
        panel.add(namePanel);
        JLabel descriptionLabel = new JLabel("Description: ");
        this.descriptionTxt = new JTextField(35);
        JButton descriptionHelpButton = this.helpButton("DD file generation help: setting the description", "The description of the published content as it will appear to the recipient when receiving the download descriptor.");
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.add(descriptionLabel);
        descriptionPanel.add(this.descriptionTxt);
        descriptionPanel.add(descriptionHelpButton);
        panel.add(descriptionPanel);
        JLabel installNotifyURLLabel = new JLabel("Install notify URL: ");
        this.installNotifyURLTxt = new JTextField(35);
        JButton installNotifyURLHelpButton = this.helpButton("DD file generation help: setting the install notify URL", "Once the content will be downloaded and installed, this URL will be notified.");
        JPanel installNotifyURLPanel = new JPanel();
        installNotifyURLPanel.add(installNotifyURLLabel);
        installNotifyURLPanel.add(this.installNotifyURLTxt);
        installNotifyURLPanel.add(installNotifyURLHelpButton);
        panel.add(installNotifyURLPanel);
        JLabel nextURLLabel = new JLabel("Next URL: ");
        this.nextURLTxt = new JTextField(35);
        JButton nextURLHelpButton = this.helpButton("DD file generation help: setting the next URL", "After downloading the content, the user will be redirected to this URL.");
        JPanel nextURLPanel = new JPanel();
        nextURLPanel.add(nextURLLabel);
        nextURLPanel.add(this.nextURLTxt);
        nextURLPanel.add(nextURLHelpButton);
        panel.add(nextURLPanel);
        JLabel iconURLLabel = new JLabel("Icon URL: ");
        this.iconURLTxt = new JTextField(35);
        JButton iconHelpButton = this.helpButton("DD file generation help: setting the iconURL", "If an icon is associated with the file to download, this field will specify where it can be found.");
        JPanel iconURLPanel = new JPanel();
        iconURLPanel.add(iconURLLabel);
        iconURLPanel.add(this.iconURLTxt);
        iconURLPanel.add(iconHelpButton);
        panel.add(iconURLPanel);
        JLabel infoURLLabel = new JLabel("Info URL: ");
        this.infoURLTxt = new JTextField(35);
        JButton infoURLHelpButton = this.helpButton("DD file generation help: setting the info URL", "Link to an URL containing information about the content");
        JPanel infoURLPanel = new JPanel();
        infoURLPanel.add(infoURLLabel);
        infoURLPanel.add(this.infoURLTxt);
        infoURLPanel.add(infoURLHelpButton);
        panel.add(infoURLPanel);
        JLabel installParamsLabel = new JLabel("Installation Parameters: ");
        this.installParamsTxt = new JTextField(35);
        JButton installParamsHelpButton = this.helpButton("DD file generation help: setting the installation parameters ", "If installing the content require any additional parameters, they should be specified here");
        JPanel installParamsPanel = new JPanel();
        installParamsPanel.add(installParamsLabel);
        installParamsPanel.add(this.installParamsTxt);
        installParamsPanel.add(installParamsHelpButton);
        panel.add(installParamsPanel);
        JLabel vendorLabel = new JLabel("Vendor: ");
        this.vendorTxt = new JTextField(35);
        JButton vendorHelpButton = this.helpButton("DD file generation help: setting the vendor", "Give information about the content ptovider.");
        JPanel vendorPanel = new JPanel();
        vendorPanel.add(vendorLabel);
        vendorPanel.add(this.vendorTxt);
        vendorPanel.add(vendorHelpButton);
        panel.add(vendorPanel);
    }

    private void addDMPanel(JPanel panel) {
        JLabel dmLabel = new JLabel("Setting for forward lock publishing: ");
        panel.add(dmLabel);
        JCheckBox boundaryStringCB = new JCheckBox("Set manually the boundary string");
        this.boundaryStringTxt = new JTextField(MIMEType.generateRandomBoundaryString(), 35);
        this.boundaryStringTxt.setEnabled(false);
        boundaryStringCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (VisualPublisher.this.boundaryStringTxt.isEnabled()) {
                    VisualPublisher.this.boundaryStringTxt.setEnabled(false);
                    VisualPublisher.this.boundaryStringTxt.setText(MIMEType.generateRandomBoundaryString());
                } else {
                    VisualPublisher.this.boundaryStringTxt.setEnabled(true);
                }
            }
        });
        JButton boundaryStringHelpButton = new JButton("?");
        boundaryStringHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "If not manually defined, the Boundary String will be a set to a random valid boudary string", "Help: setting the Boundary String", 1, null);
            }
        });
        ButtonGroup encoding = new ButtonGroup();
        JLabel encodingMsg = new JLabel("Select encoding method");
        this.binaryButton = new JRadioButton("Binary");
        this.binaryButton.setSelected(true);
        encoding.add(this.binaryButton);
        JRadioButton base64Button = new JRadioButton("Base64");
        encoding.add(base64Button);
        JButton encodingHelpButton = new JButton("?");
        encodingHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Choose if the dm file will or not be Base 64 encoded", "Help: DM encoding format", 1, null);
            }
        });
        encodingHelpButton.setAlignmentY(1.0f);
        JLabel prefixMsg = new JLabel("Filename prefix: ");
        this.prefixPreviewMsg = new JLabel("Sample file name preview: sample.dm");
        this.prefixTxt = new JTextField(35);
        this.prefixTxt.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                VisualPublisher.this.prefixPreviewMsg.setText("Sample file name preview: " + VisualPublisher.this.prefixTxt.getText() + "sample.dm");
            }
        });
        JPanel boundaryStringPanel = new JPanel();
        boundaryStringPanel.add(boundaryStringCB);
        boundaryStringPanel.add(this.boundaryStringTxt);
        boundaryStringPanel.add(boundaryStringHelpButton);
        panel.add(boundaryStringPanel);
        JPanel encodingPanel = new JPanel();
        encodingPanel.add(encodingMsg);
        encodingPanel.add(this.binaryButton);
        encodingPanel.add(base64Button);
        encodingPanel.add(encodingHelpButton);
        panel.add(encodingPanel);
        JPanel prefixPanel = new JPanel();
        prefixPanel.add(prefixMsg);
        prefixPanel.add(this.prefixTxt);
        panel.add(prefixPanel);
        this.prefixPreviewMsg.setHorizontalAlignment(0);
        panel.add(this.prefixPreviewMsg);
    }

    private JComponent makeMainPanel() {
        JPanel panel = new JPanel(false);
        panel.setLayout(new GridLayout(0, 1));
        JLabel filler = new JLabel("File selection and publishing settings");
        filler.setHorizontalAlignment(0);
        panel.add(filler);
        JLabel fileChooserLabel = new JLabel("File to publish: ");
        this.fileChooserTxt = new JTextField(35);
        JButton fileChooserButton = new JButton("Browse...");
        fileChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showOpenDialog(null);
                VisualPublisher.this.fileChooserTxt.setText(chooser.getSelectedFile().getPath());
            }
        });
        JPanel fileChooserPanel = new JPanel();
        fileChooserPanel.add(fileChooserLabel);
        fileChooserPanel.add(this.fileChooserTxt);
        fileChooserPanel.add(fileChooserButton);
        panel.add(fileChooserPanel);
        JLabel destinationChooserLabel = new JLabel("Destination directory: ");
        this.destinationChooserTxt = new JTextField(35);
        JButton destinationChooserButton = new JButton("Browse...");
        destinationChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showDialog(null, "Select this directory");
                VisualPublisher.this.destinationChooserTxt.setText(chooser.getSelectedFile().getPath());
            }
        });
        JPanel destinationChooserPanel = new JPanel();
        destinationChooserPanel.add(destinationChooserLabel);
        destinationChooserPanel.add(this.destinationChooserTxt);
        destinationChooserPanel.add(destinationChooserButton);
        panel.add(destinationChooserPanel);
        this.forwardLockCB = new JCheckBox("Generate Forward Lock (.dm) file");
        this.forwardLockCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (VisualPublisher.this.forwardLockCB.isSelected()) {
                    VisualPublisher.this.downloadDescriptorCB.setEnabled(true);
                } else {
                    VisualPublisher.this.downloadDescriptorCB.setEnabled(false);
                    VisualPublisher.this.downloadDescriptorCB.setSelected(false);
                }
            }
        });
        panel.add(this.forwardLockCB);
        this.downloadDescriptorCB = new JCheckBox("Generate Download Descriptor (.dd) file");
        this.downloadDescriptorCB.setEnabled(false);
        panel.add(this.downloadDescriptorCB);
        this.mmsGenerationCB = new JCheckBox("Generate MMS file (.mms) to send content");
        this.mmsGenerationCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (VisualPublisher.this.mmsGenerationCB.isSelected()) {
                    VisualPublisher.this.mmsSendingCB.setEnabled(true);
                } else {
                    VisualPublisher.this.mmsSendingCB.setEnabled(false);
                    VisualPublisher.this.mmsSendingCB.setSelected(false);
                }
            }
        });
        JLabel mmsHowToLabel = new JLabel("If a dm file is generated, it is this file which will be MMS wrapped.");
        panel.add(this.mmsGenerationCB);
        panel.add(mmsHowToLabel);
        this.mmsSendingCB = new JCheckBox("Send the generated MMS File");
        this.mmsSendingCB.setEnabled(false);
        panel.add(this.mmsSendingCB);
        JButton proceedButton = new JButton("Perform requested operations");
        proceedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector resultStackMessage = new Vector();
                boolean result = VisualPublisher.this.publish(new File(VisualPublisher.this.fileChooserTxt.getText()), VisualPublisher.this.forwardLockCB.isSelected(), VisualPublisher.this.downloadDescriptorCB.isSelected(), VisualPublisher.this.mmsGenerationCB.isSelected(), VisualPublisher.this.mmsSendingCB.isSelected(), resultStackMessage);
                VisualPublisher.this.popUpResultWindow(resultStackMessage, result);
            }
        });
        JPanel proceedPanel = new JPanel();
        proceedPanel.add(proceedButton);
        panel.add(proceedPanel);
        return panel;
    }

    protected void popUpResultWindow(Vector resultStackMessage, boolean correctExecution) {
        String result = new String();
        Iterator it = ((AbstractList)resultStackMessage).iterator();
        while (it.hasNext()) {
            result = String.valueOf(result) + it.next();
        }
        JOptionPane.showMessageDialog(null, result, "Command Result", correctExecution ? 1 : 0);
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sg.edu.nyp.drmPublisher.samples.VisualPublisher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((imgURL = clazz.getResource(path)) != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("DRM and MMS publisher GUI");
        frame.setDefaultCloseOperation(3);
        VisualPublisher newContentPane = new VisualPublisher();
        newContentPane.setOpaque(true);
        frame.getContentPane().add((Component)new VisualPublisher(), "Center");
        frame.pack();
        ((Component)frame).setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualPublisher.createAndShowGUI();
            }
        });
    }

    public boolean publish(File toPublish, boolean generateDmFile, boolean generateDdFile, boolean generateMmsFile, boolean mmsSending, Vector messageStack) {
        String path;
        boolean nothing = true;
        boolean errorOccured = false;
        String string = path = this.destinationChooserTxt.getText().length() != 0 ? String.valueOf(this.destinationChooserTxt.getText()) + '\\' : "";
        if (generateDmFile) {
            DMFile dmOutput;
            block40: {
                dmOutput = null;
                try {
                    nothing = false;
                    dmOutput = new DMFile(toPublish);
                    dmOutput.setBoundaryString(this.boundaryStringTxt.getText());
                    dmOutput.setBinaryEncoding(this.binaryButton.isSelected());
                    toPublish = dmOutput.generateDMFile(this.prefixTxt.getText(), path);
                    messageStack.add("DM file generated \n");
                }
                catch (IOException e) {
                    errorOccured = true;
                    messageStack.add("A problem Happened during the DMFileGeneration \n");
                    if (generateDdFile) {
                        messageStack.add("The dd File could not be generated");
                        generateDdFile = false;
                    }
                }
                catch (IndexOutOfBoundsException e2) {
                    errorOccured = true;
                    messageStack.add("Unable to proceed with the input file. \n");
                    if (!generateDdFile) break block40;
                    messageStack.add("The dd File could not be generated");
                    generateDdFile = false;
                }
            }
            if (generateDdFile) {
                try {
                    DDFile ddFile = new DDFile(toPublish, dmOutput.getContentType());
                    if (this.nameTxt.getText().length() != 0) {
                        ddFile.setName(this.nameTxt.getText());
                    }
                    if (this.descriptionTxt.getText().length() != 0) {
                        ddFile.setDescription(this.descriptionTxt.getText());
                    }
                    if (this.installNotifyURLTxt.getText().length() != 0) {
                        ddFile.setInstallNotifyURI(this.installNotifyURLTxt.getText());
                    }
                    if (this.nextURLTxt.getText().length() != 0) {
                        ddFile.setNextUrl(this.nextURLTxt.getText());
                    }
                    if (this.infoURLTxt.getText().length() != 0) {
                        ddFile.setInfoUrl(this.infoURLTxt.getText());
                    }
                    if (this.iconURLTxt.getText().length() != 0) {
                        ddFile.setIconUrl(this.iconURLTxt.getText());
                    }
                    if (this.installParamsTxt.getText().length() != 0) {
                        ddFile.setInstallNotifyURI(this.installParamsTxt.getText());
                    }
                    if (this.vendorTxt.getText().length() != 0) {
                        ddFile.setVendor(this.vendorTxt.getText());
                    }
                    if (this.objectURITxt.getText().length() != 0) {
                        ddFile.setObjectURI(this.objectURITxt.getText());
                    }
                    ddFile.generateDDFile(path);
                    messageStack.add("DD file GENERATED \n");
                }
                catch (IOException e1) {
                    errorOccured = true;
                    e1.printStackTrace();
                    messageStack.add("An error occured during the ddFile generation. \n");
                }
            }
        }
        if (generateMmsFile) {
            nothing = false;
            try {
                String from = null;
                String to = null;
                String cc = null;
                String bcc = null;
                if (this.fromTxt.getText().length() != 0) {
                    try {
                        from = MMSFile.formatAddress((String)this.fromTxt.getText());
                    }
                    catch (NonMMSAddressException e1) {
                        errorOccured = true;
                        messageStack.add("The From address is not a valid MMS address. \n");
                    }
                }
                if (this.toTxt.getText().length() != 0) {
                    try {
                        to = MMSFile.formatAddress((String)this.toTxt.getText());
                    }
                    catch (NonMMSAddressException e1) {
                        errorOccured = true;
                        messageStack.add("The To address is not a valid MMS address. \n");
                    }
                }
                if (this.ccTxt.getText().length() != 0) {
                    try {
                        cc = MMSFile.formatAddress((String)this.ccTxt.getText());
                    }
                    catch (NonMMSAddressException e1) {
                        errorOccured = true;
                        messageStack.add("The Cc address is not a valid MMS address. \n");
                    }
                }
                if (this.bccTxt.getText().length() != 0) {
                    try {
                        bcc = MMSFile.formatAddress((String)this.bccTxt.getText());
                    }
                    catch (NonMMSAddressException e1) {
                        errorOccured = true;
                        messageStack.add("The Bcc address is not a valid MMS address. \n");
                    }
                }
                MMSFile output = new MMSFile(from, to, cc, bcc);
                output.AddContent(toPublish);
                if (this.transactionIdTxt.getText().length() != 0) {
                    output.setTransactionId(this.transactionIdTxt.getText());
                }
                if (this.subjectTxt.getText().length() != 0) {
                    output.setSubject(this.subjectTxt.getText());
                }
                if (this.mmsFileNameTxt.getText().length() != 0) {
                    output.setMmsFileName(this.mmsFileNameTxt.getText());
                }
                if (output.generateMMSFile(path) != null) {
                    messageStack.add("MMS file GENERATED \n");
                } else {
                    errorOccured = true;
                    messageStack.add("An error Occured during the MMS File generation. \n");
                    if (mmsSending) {
                        messageStack.add("No mms will be send. \n");
                        mmsSending = false;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                errorOccured = true;
                messageStack.add("An error occured during the MMS File generation: Incorrect Parameters \n");
                messageStack.add(String.valueOf(e.getMessage()) + '\n');
            }
            if (mmsSending) {
                messageStack.add("Sorry, the MMS sending option is not yet avaible. \n");
            }
        }
        if (nothing) {
            errorOccured = true;
            messageStack.add("No actions have been selected!");
        }
        return !errorOccured;
    }

    JButton helpButton(final String helpTopic, final String helpMessage) {
        JButton toReturn = new JButton("?");
        toReturn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, helpMessage, helpTopic, 1, null);
            }
        });
        return toReturn;
    }
}

