/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.nyp.drmPublisher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Base64Codec {
    public static char[] encodeBase64(byte[] toConvert) {
        int nbBytes = toConvert.length;
        StringBuffer buffer = new StringBuffer();
        int addedCariage = 0;
        int i = 0;
        while (i < nbBytes) {
            int currentLength = Math.min(3, nbBytes - i);
            byte[] currentBytes = new byte[currentLength];
            System.arraycopy(toConvert, i, currentBytes, 0, currentLength);
            buffer.append(Base64Codec.encodeThreeBytes(currentBytes));
            if ((buffer.length() - addedCariage) % 76 == 0) {
                ++addedCariage;
                buffer.append('\n');
            }
            i += 3;
        }
        return buffer.toString().toCharArray();
    }

    public static byte[] decodeBase64(char[] toDecode) {
        if (toDecode.length % 4 != 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer charBuffer = new StringBuffer();
        StringBuffer bytesBuffer = new StringBuffer();
        charBuffer.append(toDecode);
        Pattern p = Pattern.compile("[^a-zA-Z0-9\\+\\/=]");
        Matcher m = p.matcher(charBuffer.toString());
        charBuffer = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(charBuffer, "");
        }
        m.appendTail(charBuffer);
        int nbChars = charBuffer.length();
        int i = 0;
        while (i < nbChars) {
            char[] tmpChars = new char[4];
            charBuffer.getChars(i, i + 4, tmpChars, 0);
            bytesBuffer.append(new String(Base64Codec.decodeFourChars(tmpChars)));
            i += 4;
        }
        return bytesBuffer.toString().getBytes();
    }

    protected static char[] encodeThreeBytes(byte[] threeBytes) {
        int bitStream = 0;
        char[] toReturn = new char[4];
        int paddling = 0;
        if (threeBytes.length > 3) {
            throw new IllegalArgumentException();
        }
        if (threeBytes.length < 3) {
            int toPaddleSize = threeBytes.length;
            byte[] inputCopy = new byte[toPaddleSize];
            System.arraycopy(threeBytes, 0, inputCopy, 0, toPaddleSize);
            threeBytes = new byte[3];
            System.arraycopy(inputCopy, 0, threeBytes, 0, toPaddleSize);
            while (toPaddleSize + paddling < 3) {
                threeBytes[toPaddleSize + paddling] = 0;
                ++paddling;
            }
        }
        int i = 0;
        while (i <= 2) {
            bitStream += threeBytes[i] << 8 * (2 - i);
            ++i;
        }
        i = 3;
        while (i >= 0) {
            toReturn[i] = Base64Codec.encodeSixBits((byte)(bitStream & 0x3F));
            bitStream >>= 6;
            --i;
        }
        while (paddling-- > 0) {
            toReturn[3 - paddling] = 61;
        }
        return toReturn;
    }

    protected static char encodeSixBits(byte six) {
        if ((six & 0xC0) != 0) {
            throw new IllegalArgumentException();
        }
        if (six < 26) {
            return (char)(65 + six);
        }
        if (six < 52) {
            return (char)(97 + (six - 26));
        }
        if (six < 62) {
            return (char)(48 + (six - 52));
        }
        if (six == 62) {
            return '+';
        }
        return '/';
    }

    protected static byte[] decodeFourChars(char[] toDecode) {
        if (toDecode.length != 4) {
            throw new IllegalArgumentException();
        }
        int bitStream = 0;
        int paddling = 0;
        int i = 3;
        while (i >= 0) {
            if (toDecode[i] != '=') break;
            ++paddling;
            --i;
        }
        if (paddling > 2) {
            throw new IllegalArgumentException();
        }
        byte[] toReturn = new byte[3 - paddling];
        i = 0;
        while (i < 4) {
            bitStream += Base64Codec.decodeSixBits(toDecode[i]) << 6 * (3 - i);
            ++i;
        }
        bitStream >>= 8 * paddling;
        i = toReturn.length - 1;
        while (i >= 0) {
            toReturn[i] = (byte)(bitStream & 0xFF);
            bitStream >>= 8;
            --i;
        }
        return toReturn;
    }

    protected static byte decodeSixBits(char c) {
        if (c == '=') {
            return 0;
        }
        if (c >= 'A' && c <= 'Z') {
            return (byte)(c - 65);
        }
        if (c >= 'a' && c <= 'z') {
            return (byte)(c - 97 + 26);
        }
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48 + 52);
        }
        if (c == '+') {
            return 62;
        }
        return 63;
    }
}

