/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.nyp.drmPublisher;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import sg.edu.nyp.drmPublisher.Base64Codec;
import sg.edu.nyp.drmPublisher.MIMEType;

public class DMFile
implements Serializable {
    private String boundaryString = null;
    private String contentType = null;
    private boolean binaryEncoding = true;
    private File contentFile;
    private boolean hasBeenWritten;

    public DMFile(boolean binaryEncoding, File contentFile) {
        this(contentFile);
        this.binaryEncoding = binaryEncoding;
    }

    public DMFile(File contentFile) {
        this.contentFile = contentFile;
        String fileName = contentFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf(46)).substring(1);
        this.contentType = new MIMEType().getMIMEContentType(extension);
        this.hasBeenWritten = false;
    }

    public File generateDMFile(String prefix, String path) throws IOException {
        String dmName = this.contentFile.getName();
        if (this.boundaryString == null) {
            this.setRandomBoundaryString();
        }
        dmName = String.valueOf(prefix) + dmName.substring(0, dmName.lastIndexOf(46)) + ".dm";
        File output = new File(String.valueOf(path) + dmName);
        FileOutputStream fos = new FileOutputStream(output);
        DataOutputStream out = new DataOutputStream(fos);
        out.write(("--" + this.boundaryString + '\r' + '\n').getBytes());
        out.write(("Content-type: " + this.contentType + '\r' + '\n').getBytes());
        out.write(("Content-Transfer-Encoding: " + (this.binaryEncoding ? "binary" : "base64") + '\r' + '\n').getBytes());
        out.write(13);
        out.write(10);
        FileInputStream fis = new FileInputStream(this.contentFile);
        int nbBytes = fis.available();
        byte[] rawBytes = new byte[nbBytes];
        if (fis.read(rawBytes) != nbBytes) {
            throw new IOException();
        }
        if (this.binaryEncoding) {
            out.write(rawBytes);
        } else {
            out.write(new String(Base64Codec.encodeBase64(rawBytes)).getBytes());
        }
        out.write(13);
        out.write(10);
        out.write(("--" + this.boundaryString + "--").getBytes());
        fis.close();
        fos.close();
        this.hasBeenWritten = true;
        return output;
    }

    public File generateDMFile(String prefix) throws IOException {
        return this.generateDMFile(prefix, "");
    }

    public boolean isBinaryEncoding() {
        return this.binaryEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getContentFile() {
        return this.contentFile;
    }

    public void setBinaryEncoding(boolean b) {
        this.binaryEncoding = b;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public boolean isHasBeenWritten() {
        return this.hasBeenWritten;
    }

    public void setRandomBoundaryString() {
        String toSet = MIMEType.generateRandomBoundaryString();
        if (!this.setBoundaryString(toSet.toString())) {
            System.out.println("Unexpected error: an incorrect random boundary String has been generated.");
            System.out.println(toSet);
            System.out.println("The program will now exit.");
            System.exit(1);
        }
    }

    public String getBoundaryString() {
        return this.boundaryString;
    }

    public boolean setBoundaryString(String string) {
        if (MIMEType.isValidBoundaryString(string)) {
            this.boundaryString = string;
            return true;
        }
        return false;
    }
}

