/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.nyp.drmPublisher;

import java.io.File;
import java.util.HashMap;

public class MIMEType {
    protected HashMap ex2Type = new HashMap();

    public MIMEType() {
        this.initialize();
    }

    public String getMIMEContentType(String fileExtension) {
        return (String)this.ex2Type.get(fileExtension);
    }

    public String getMIMEContentType(File file) {
        String fileName = file.getName();
        String ext = fileName.substring(fileName.lastIndexOf(46)).substring(1);
        return this.getMIMEContentType(ext);
    }

    protected void initialize() {
        this.ex2Type.put("txt", "text/plain");
        this.ex2Type.put("htm", "text/html");
        this.ex2Type.put("html", "text/html");
        this.ex2Type.put("gif", "image/gif");
        this.ex2Type.put("jpg", "image/jpeg");
        this.ex2Type.put("wbmp", "image/vnd.wap.wbmp");
        this.ex2Type.put("png", "image/png");
        this.ex2Type.put("svg", "image/svg");
        this.ex2Type.put("svgz", "image/svg");
        this.ex2Type.put("ota", "image/x-ota-bitmap");
        this.ex2Type.put("bmp", "image/x-bmp");
        this.ex2Type.put("mbm", "image/x-epoc-mbm");
        this.ex2Type.put("tif", "image/tiff");
        this.ex2Type.put("tiff", "image/tiff");
        this.ex2Type.put("Ringtone", "application/vnd.nokia.ringing-tone");
        this.ex2Type.put("mel", "text/mel");
        this.ex2Type.put("emy", "text/x-emelody");
        this.ex2Type.put("imy", "text/x-imelody");
        this.ex2Type.put("amr", "audio/amr");
        this.ex2Type.put("evr", "audio/evrc");
        this.ex2Type.put("Smv", "audio/Smv");
        this.ex2Type.put("mid", "audio/x-midi");
        this.ex2Type.put("midi", "audio/x-midi");
        this.ex2Type.put("mmf", "application/x-smaf");
        this.ex2Type.put("wav", "audio/x-wav");
        this.ex2Type.put("mps", "audio/mps");
        this.ex2Type.put("wve", "audio/x-sibo");
        this.ex2Type.put("rmf", "audio/rmf");
        this.ex2Type.put("ra", "audio/x-pn-realaudio");
        this.ex2Type.put("ram", "audio/x-pn-realaudio");
        this.ex2Type.put("rm", "audio/x-pn-realaudio");
        this.ex2Type.put("rmp", "audio/x-pn-realaudio");
        this.ex2Type.put("au", "audio/basic");
        this.ex2Type.put("wma", "audio/x-ms-wma");
        this.ex2Type.put("qcp", "audio/qcp");
        this.ex2Type.put("avi", "video/avi");
        this.ex2Type.put("3gp", "video/3gp");
        this.ex2Type.put("mpeg", "video/mpeg");
        this.ex2Type.put("h263", "video/x-h263");
        this.ex2Type.put("qt", "video/quicktime");
        this.ex2Type.put("jar", "application/java-archive");
        this.ex2Type.put("jad", "text/vnd.sun.j2me.app-descriptor");
        this.ex2Type.put("dm", "application/vnd.oma.drm.message");
    }

    public static boolean isValidBoundaryString(String string) {
        if (string.length() > 70) {
            return false;
        }
        return string.matches("[a-zA-Z0-9'\\/()+_,-.:=?]+");
    }

    public static String generateRandomBoundaryString() {
        String otherChars = "'/()+_,-.:=?";
        String toSet = new String();
        int length = (int)Math.ceil(Math.random() * 70.0);
        int i = 0;
        while (i < length) {
            int toAdd = (int)(Math.random() * 74.0);
            toSet = toAdd < 26 ? String.valueOf(toSet) + (char)(97 + toAdd) : (toAdd < 52 ? String.valueOf(toSet) + (char)(65 + toAdd - 26) : (toAdd < 62 ? String.valueOf(toSet) + (char)(48 + toAdd - 52) : String.valueOf(toSet) + "'/()+_,-.:=?".charAt(toAdd - 62)));
            ++i;
        }
        if (!MIMEType.isValidBoundaryString(toSet.toString())) {
            System.out.println("Unexpected error: an incorrect random boundary String has been generated.");
            System.out.println(toSet);
            return null;
        }
        return toSet.toString();
    }
}

