/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.nyp.drmPublisher;

import com.nokia.mms.MMAddress;
import com.nokia.mms.MMContent;
import com.nokia.mms.MMEncoder;
import com.nokia.mms.MMMessage;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Vector;
import sg.edu.nyp.drmPublisher.MIMEType;
import sg.edu.nyp.drmPublisher.NonMMSAddressException;

public class MMSFile {
    protected String mmsFileName;
    protected MMMessage mms = new MMMessage();

    public MMSFile(String from, String to, String cc, String bcc) {
        boolean isValid = false;
        this.mms.setMessageType((byte)-128);
        this.mms.setTransactionId("0123456789");
        this.mms.setVersion((byte)-112);
        if (from == null) {
            throw new IllegalArgumentException("The from field is mandatory.");
        }
        this.mms.setFrom(from);
        if (to != null) {
            this.mms.addToAddress(to);
            isValid = true;
        }
        if (cc != null) {
            this.mms.addCcAddress(cc);
            isValid = true;
        }
        if (bcc != null) {
            this.mms.addBccAddress(bcc);
            isValid = true;
        }
        if (!isValid) {
            throw new IllegalArgumentException("At least one of the fields To/Cc/Bcc is mandatory.");
        }
        this.mms.setContentType("application/vnd.wap.multipart.mixed");
    }

    public File generateMMSFile() {
        return this.generateMMSFile("");
    }

    public File generateMMSFile(String path) {
        MMEncoder encoder = new MMEncoder();
        encoder.setMessage(this.mms);
        try {
            encoder.encodeMessage();
            byte[] out = encoder.getMessage();
            return this.createMmsFile(out, String.valueOf(path) + (this.mmsFileName == null ? "TestMMS" : this.mmsFileName) + ".mms");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void AddContent(File file) {
        MMContent dmPart = new MMContent();
        byte[] b2 = this.readFile(file);
        dmPart.setContent(b2, 0, b2.length);
        dmPart.setContentId(file.getName());
        if (this.mmsFileName == null) {
            this.mmsFileName = file.getName();
        }
        dmPart.setType(new MIMEType().getMIMEContentType(file));
        this.mms.addContent(dmPart);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFile(File file) {
        int fileSize = 0;
        RandomAccessFile fileH = null;
        try {
            fileH = new RandomAccessFile(file, "r");
            fileSize = (int)fileH.length();
        }
        catch (IOException ioErr) {
            System.err.println("Cannot find " + file.getName());
            System.err.println(ioErr);
            System.exit(200);
        }
        byte[] buf = new byte[fileSize];
        int i = 0;
        try {
            try {
                while (true) {
                    buf[i++] = fileH.readByte();
                }
            }
            catch (EOFException e) {
                return buf;
            }
        }
        catch (IOException ioErr) {
            System.out.println("ERROR in reading of file" + file);
        }
        return buf;
    }

    private File createMmsFile(byte[] output, String filename) {
        try {
            File f = new File(filename);
            FileOutputStream out = new FileOutputStream(f);
            out.write(output);
            out.close();
            return f;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void addBccAddress(String arg0) {
        this.mms.addBccAddress(arg0);
    }

    public void addCcAddress(String arg0) {
        this.mms.addCcAddress(arg0);
    }

    public void addToAddress(String arg0) {
        this.mms.addToAddress(arg0);
    }

    public void clearBcc() {
        this.mms.clearBcc();
    }

    public void clearCc() {
        this.mms.clearCc();
    }

    public void clearTo() {
        this.mms.clearTo();
    }

    public Vector getBcc() {
        return this.mms.getBcc();
    }

    public Vector getCc() {
        return this.mms.getCc();
    }

    public MMContent getContent(int arg0) {
        return this.mms.getContent(arg0);
    }

    public MMContent getContent(String arg0) {
        return this.mms.getContent(arg0);
    }

    public String getContentType() {
        return this.mms.getContentType();
    }

    public Date getDate() {
        return this.mms.getDate();
    }

    public boolean getDeliveryReport() {
        return this.mms.getDeliveryReport();
    }

    public Date getDeliveryTime() {
        return this.mms.getDeliveryTime();
    }

    public Date getExpiry() {
        return this.mms.getExpiry();
    }

    public MMAddress getFrom() {
        return this.mms.getFrom();
    }

    public byte getMessageClass() {
        return this.mms.getMessageClass();
    }

    public String getMessageId() {
        return this.mms.getMessageId();
    }

    public byte getMessageStatus() {
        return this.mms.getMessageStatus();
    }

    public byte getMessageType() {
        return this.mms.getMessageType();
    }

    public String getMultipartRelatedType() {
        return this.mms.getMultipartRelatedType();
    }

    public int getNumContents() {
        return this.mms.getNumContents();
    }

    public MMContent getPresentation() {
        return this.mms.getPresentation();
    }

    public String getPresentationId() {
        return this.mms.getPresentationId();
    }

    public byte getPriority() {
        return this.mms.getPriority();
    }

    public boolean getReadReply() {
        return this.mms.getReadReply();
    }

    public byte getSenderVisibility() {
        return this.mms.getSenderVisibility();
    }

    public String getSubject() {
        return this.mms.getSubject();
    }

    public Vector getTo() {
        return this.mms.getTo();
    }

    public String getTransactionId() {
        return this.mms.getTransactionId();
    }

    public byte getVersion() {
        return this.mms.getVersion();
    }

    public String getVersionAsString() {
        return this.mms.getVersionAsString();
    }

    public boolean isBccAvailable() {
        return this.mms.isBccAvailable();
    }

    public boolean isCcAvailable() {
        return this.mms.isCcAvailable();
    }

    public boolean isContentTypeAvailable() {
        return this.mms.isContentTypeAvailable();
    }

    public boolean isDateAvailable() {
        return this.mms.isDateAvailable();
    }

    public boolean isDeliveryReportAvailable() {
        return this.mms.isDeliveryReportAvailable();
    }

    public boolean isDeliveryTimeAbsolute() {
        return this.mms.isDeliveryTimeAbsolute();
    }

    public boolean isDeliveryTimeAvailable() {
        return this.mms.isDeliveryTimeAvailable();
    }

    public boolean isExpiryAbsolute() {
        return this.mms.isExpiryAbsolute();
    }

    public boolean isExpiryAvailable() {
        return this.mms.isExpiryAvailable();
    }

    public boolean isFromAvailable() {
        return this.mms.isFromAvailable();
    }

    public boolean isMessageClassAvailable() {
        return this.mms.isMessageClassAvailable();
    }

    public boolean isMessageIdAvailable() {
        return this.mms.isMessageIdAvailable();
    }

    public boolean isMessageTypeAvailable() {
        return this.mms.isMessageTypeAvailable();
    }

    public boolean isPresentationAvailable() {
        return this.mms.isPresentationAvailable();
    }

    public boolean isPriorityAvailable() {
        return this.mms.isPriorityAvailable();
    }

    public boolean isReadReplyAvailable() {
        return this.mms.isReadReplyAvailable();
    }

    public boolean isSenderVisibilityAvailable() {
        return this.mms.isSenderVisibilityAvailable();
    }

    public boolean isStatusAvailable() {
        return this.mms.isStatusAvailable();
    }

    public boolean isSubjectAvailable() {
        return this.mms.isSubjectAvailable();
    }

    public boolean isToAvailable() {
        return this.mms.isToAvailable();
    }

    public boolean isTransactionIdAvailable() {
        return this.mms.isTransactionIdAvailable();
    }

    public boolean isVersionAvailable() {
        return this.mms.isVersionAvailable();
    }

    public void setContentType(String arg0) {
        this.mms.setContentType(arg0);
    }

    public void setDate(Date arg0) {
        this.mms.setDate(arg0);
    }

    public void setDeliveryReport(boolean arg0) {
        this.mms.setDeliveryReport(arg0);
    }

    public void setDeliveryTime(Date arg0) {
        this.mms.setDeliveryTime(arg0);
    }

    public void setDeliveryTimeAbsolute(boolean arg0) {
        this.mms.setDeliveryTimeAbsolute(arg0);
    }

    public void setExpiry(Date arg0) {
        this.mms.setExpiry(arg0);
    }

    public void setExpiryAbsolute(boolean arg0) {
        this.mms.setExpiryAbsolute(arg0);
    }

    public void setFrom(String arg0) {
        this.mms.setFrom(arg0);
    }

    public void setMessageClass(byte arg0) {
        this.mms.setMessageClass(arg0);
    }

    public void setMessageId(String arg0) {
        this.mms.setMessageId(arg0);
    }

    public void setMessageStatus(byte arg0) {
        this.mms.setMessageStatus(arg0);
    }

    public void setMessageType(byte arg0) {
        this.mms.setMessageType(arg0);
    }

    public void setMultipartRelatedType(String arg0) {
        this.mms.setMultipartRelatedType(arg0);
    }

    public void setPresentationId(String arg0) {
        this.mms.setPresentationId(arg0);
    }

    public void setPriority(byte arg0) {
        this.mms.setPriority(arg0);
    }

    public void setReadReply(boolean arg0) {
        this.mms.setReadReply(arg0);
    }

    public void setSenderVisibility(byte arg0) {
        this.mms.setSenderVisibility(arg0);
    }

    public void setSubject(String arg0) {
        this.mms.setSubject(arg0);
    }

    public void setTransactionId(String arg0) {
        this.mms.setTransactionId(arg0);
    }

    public void setVersion(byte arg0) {
        this.mms.setVersion(arg0);
    }

    public String getMmsFileName() {
        return this.mmsFileName;
    }

    public void setMmsFileName(String string) {
        this.mmsFileName = string;
    }

    public static String formatAddress(String currentAddress) throws NonMMSAddressException {
        if (currentAddress.startsWith("+")) {
            StringBuffer toReturn = new StringBuffer();
            toReturn.append('+');
            int i = 1;
            int n = currentAddress.length();
            while (i < n) {
                char c = currentAddress.charAt(i);
                if (Character.isDigit(c)) {
                    toReturn.append(c);
                }
                ++i;
            }
            toReturn.append("/TYPE=PLMN");
            return toReturn.toString();
        }
        int atIndex = currentAddress.indexOf(64);
        if (atIndex > 0) {
            return new StringBuffer(currentAddress).insert(atIndex, "/TYPE=RFC822").toString();
        }
        throw new NonMMSAddressException();
    }
}

