package sg.edu.nyp.drmPublisher.samples;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import sg.edu.nyp.drmPublisher.DDFile;
import sg.edu.nyp.drmPublisher.DMFile;
import sg.edu.nyp.drmPublisher.MIMEType;
import sg.edu.nyp.drmPublisher.MMSFile;
import sg.edu.nyp.drmPublisher.NonMMSAddressException;

/**
 * @author Pierre Trocme
 */
public class VisualPublisher extends JPanel {
	private JTextField objectURITxt;
	private JTextField destinationChooserTxt;
	private JTextField mmsFileNameTxt;
	private JTextField subjectTxt;
	private JTextField transactionIdTxt;
	private JTextField bccTxt;
	private JTextField ccTxt;
	private JTextField toTxt;
	private JTextField fromTxt;
	private JTextField vendorTxt;
	private JTextField installParamsTxt;
	private JTextField infoURLTxt;
	private JTextField iconURLTxt;
	private JTextField nextURLTxt;
	private JTextField installNotifyURLTxt;
	private JTextField descriptionTxt;
	private JTextField nameTxt;
	private JTextField boundaryStringTxt;
	private JCheckBox downloadDescriptorCB;
	private JCheckBox forwardLockCB;
	private JCheckBox mmsSendingCB;
	private JCheckBox mmsGenerationCB;
	private JTextField fileChooserTxt;
	private JRadioButton binaryButton;
	private JTextField prefixTxt;
	private JLabel prefixPreviewMsg;

	public VisualPublisher() {
		super(new GridLayout(1, 1));

		JTabbedPane tabbedPane = new JTabbedPane();
		ImageIcon icon = createImageIcon("images/middle.gif");

		JComponent mainPanel = makeMainPanel();
		tabbedPane.addTab(
			"General Options",
			icon,
			mainPanel,
			"Click Here for setting up general options");
		tabbedPane.setMnemonicAt(0, KeyEvent.VK_1);

		JComponent DRMPanel = makeDRMPanel();
		tabbedPane.addTab(
			"OMA DRM options",
			icon,
			DRMPanel,
			"Click Here for the Forward Lock options");
		tabbedPane.setMnemonicAt(1, KeyEvent.VK_2);

		JComponent MMSPanel = makeMMSPanel();
		MMSPanel.setPreferredSize(new Dimension(410, 50));
		tabbedPane.addTab(
			"MMS Options",
			icon,
			MMSPanel,
			"Click here for the Multimedia Messenging Service Options");
		tabbedPane.setMnemonicAt(2, KeyEvent.VK_3);

		//Add the tabbed pane to this panel.
		add(tabbedPane);

		//Uncomment the following line to use scrolling tabs.
		tabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
	}

	/**
	 * Build the MMS composition pannel.
	 * @return the MMS composition panel.
	 */
	private JComponent makeMMSPanel() {
		JPanel panel = new JPanel(false);
		panel.setLayout(new GridLayout(0, 1));

		JPanel introPanel = new JPanel();
		JLabel filler = new JLabel("Multimedia Messenging (MMS) Options");
		filler.setHorizontalAlignment(JLabel.CENTER);
		JButton addressHelpButton = new JButton("?");
		addressHelpButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(
					null,
					"The from, and at least one of the to/cc/bcc address are mandatory. \n "
						+ "They can be either email address or phone numbers starting with the + country indicator character \n"
						+ "Examples: me@home.net, +65 456 892",
					"Help: MMS addressing",
					JOptionPane.INFORMATION_MESSAGE,
					null);
			}
		});
		addressHelpButton.setAlignmentY(JButton.RIGHT_ALIGNMENT);
		introPanel.add(filler);
		introPanel.add(addressHelpButton);
		panel.add(introPanel);

		JLabel fromLabel = new JLabel("From: ");
		fromTxt = new JTextField(35);
		JPanel fromPanel = new JPanel();
		JLabel fromStar = new JLabel("*");
		fromPanel.add(fromLabel);
		fromPanel.add(fromTxt);
		fromPanel.add(fromStar);
		panel.add(fromPanel);

		JLabel toLabel = new JLabel("To: ");
		toTxt = new JTextField(35);
		JLabel toStar = new JLabel("*");
		JPanel toPanel = new JPanel();
		toPanel.add(toLabel);
		toPanel.add(toTxt);
		toPanel.add(toStar);
		panel.add(toPanel);

		JLabel ccLabel = new JLabel("Cc: ");
		ccTxt = new JTextField(35);
		JLabel ccStar = new JLabel("*");
		JPanel ccPanel = new JPanel();
		ccPanel.add(ccLabel);
		ccPanel.add(ccTxt);
		ccPanel.add(ccStar);
		panel.add(ccPanel);

		JLabel bccLabel = new JLabel("Bcc: ");
		bccTxt = new JTextField(35);
		JLabel bccStar = new JLabel("*");
		JPanel bccPanel = new JPanel();
		bccPanel.add(bccLabel);
		bccPanel.add(bccTxt);
		bccPanel.add(bccStar);
		panel.add(bccPanel);

		JLabel mmsFileNameLabel = new JLabel("MMS file name: ");
		JLabel mmsExtensionLabel = new JLabel(".mms");
		JLabel mmsFileName2Label =
			new JLabel("If let empty, the name will be set to file_to_publish.mms");
		mmsFileNameTxt = new JTextField(35);
		JPanel mmsFileNamePanel = new JPanel();
		mmsFileNamePanel.add(mmsFileNameLabel);
		mmsFileNamePanel.add(mmsFileNameTxt);
		mmsFileNamePanel.add(mmsExtensionLabel);
		panel.add(mmsFileNamePanel);
		panel.add(mmsFileName2Label);

		JLabel subjectLabel = new JLabel("Subject: ");
		subjectTxt = new JTextField(35);
		JPanel subjectPanel = new JPanel();
		subjectPanel.add(subjectLabel);
		subjectPanel.add(subjectTxt);
		panel.add(subjectPanel);

		JLabel transactionIdLabel = new JLabel("Transaction ID: ");
		transactionIdTxt = new JTextField("1234567890", 35);
		JButton transactioIdHelpButton = new JButton("?");
		transactioIdHelpButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(
					null,
					"The transaction ID will be used by the MMSC to identify a direct reply to this MMS. \n"
						+ "It can be any alpha numerical String.",
					"Help: MMS Transaction Id",
					JOptionPane.INFORMATION_MESSAGE,
					null);
			}
		});
		JPanel transactionIdPanel = new JPanel();
		transactionIdPanel.add(transactionIdLabel);
		transactionIdPanel.add(transactionIdTxt);
		transactionIdPanel.add(transactioIdHelpButton);
		panel.add(transactionIdPanel);

		JLabel mandatory =
			new JLabel("*: The from parameters and at least one of -to/-cc/-bcc are mandatory.");
		panel.add(mandatory);

		return panel;
	}

	/**
	 * Build the DRM options panel.
	 * @return the DRM options panel.
	 */
	private JComponent makeDRMPanel() {
		JPanel panel = new JPanel(false);
		JLabel warningLabel =
			new JLabel("Warning : the dd and dm file will be generated only if requested on the General Options tab");

		panel.setLayout(new GridLayout(0, 1));
		JSeparator separator = new JSeparator();

		addDMPanel(panel);
		panel.add(separator);
		addDDPanel(panel);
		panel.add(warningLabel);
		return panel;
	}

	/**
	 * Add the download descriptor options panel to the specified panel.
	 * @param panel	the destination panel.
	 */
	private void addDDPanel(JPanel panel) {
		JLabel ddLabel = new JLabel("Download descriptor (.dd) file options: ");
		panel.add(ddLabel);

		JLabel objectURILabel = new JLabel("Object URI: ");
		JLabel objectURIWLabel =
			new JLabel("Fill this field only if the publishing location is different from the current location");
		objectURITxt = new JTextField(35);
		JPanel objectURIPanel = new JPanel();
		objectURIPanel.add(objectURILabel);
		objectURIPanel.add(objectURITxt);
		panel.add(objectURIPanel);
		objectURIWLabel.setHorizontalAlignment(JLabel.CENTER);
		panel.add(objectURIWLabel);

		JLabel nameLabel = new JLabel("Name: ");
		nameTxt = new JTextField(35);
		JButton nameHelpButton = new JButton("?");
		nameHelpButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(
					null,
					"The name of the published content as it will appear to the recipient when receiving the download descriptor.",
					"DD file generation help: setting the name",
					JOptionPane.INFORMATION_MESSAGE,
					null);
			}
		});
		JPanel namePanel = new JPanel();
		namePanel.add(nameLabel);
		namePanel.add(nameTxt);
		namePanel.add(nameHelpButton);
		panel.add(namePanel);

		JLabel descriptionLabel = new JLabel("Description: ");
		descriptionTxt = new JTextField(35);
		JButton descriptionHelpButton =
			helpButton(
				"DD file generation help: setting the description",
				"The description of the published content as it will appear to the recipient when receiving the download descriptor.");
		JPanel descriptionPanel = new JPanel();
		descriptionPanel.add(descriptionLabel);
		descriptionPanel.add(descriptionTxt);
		descriptionPanel.add(descriptionHelpButton);
		panel.add(descriptionPanel);

		JLabel installNotifyURLLabel = new JLabel("Install notify URL: ");
		installNotifyURLTxt = new JTextField(35);
		JButton installNotifyURLHelpButton =
			helpButton(
				"DD file generation help: setting the install notify URL",
				"Once the content will be downloaded and installed, this URL will be notified.");
		JPanel installNotifyURLPanel = new JPanel();
		installNotifyURLPanel.add(installNotifyURLLabel);
		installNotifyURLPanel.add(installNotifyURLTxt);
		installNotifyURLPanel.add(installNotifyURLHelpButton);
		panel.add(installNotifyURLPanel);

		JLabel nextURLLabel = new JLabel("Next URL: ");
		nextURLTxt = new JTextField(35);
		JButton nextURLHelpButton =
			helpButton(
				"DD file generation help: setting the next URL",
				"After downloading the content, the user will be redirected to this URL.");

		JPanel nextURLPanel = new JPanel();
		nextURLPanel.add(nextURLLabel);
		nextURLPanel.add(nextURLTxt);
		nextURLPanel.add(nextURLHelpButton);
		panel.add(nextURLPanel);

		JLabel iconURLLabel = new JLabel("Icon URL: ");
		iconURLTxt = new JTextField(35);
		JButton iconHelpButton =
			helpButton(
				"DD file generation help: setting the iconURL",
				"If an icon is associated with the file to download, this field will specify where it can be found.");
		JPanel iconURLPanel = new JPanel();
		iconURLPanel.add(iconURLLabel);
		iconURLPanel.add(iconURLTxt);
		iconURLPanel.add(iconHelpButton);
		panel.add(iconURLPanel);

		JLabel infoURLLabel = new JLabel("Info URL: ");
		infoURLTxt = new JTextField(35);
		JButton infoURLHelpButton =
			helpButton(
				"DD file generation help: setting the info URL",
				"Link to an URL containing information about the content");
		JPanel infoURLPanel = new JPanel();
		infoURLPanel.add(infoURLLabel);
		infoURLPanel.add(infoURLTxt);
		infoURLPanel.add(infoURLHelpButton);
		panel.add(infoURLPanel);

		JLabel installParamsLabel = new JLabel("Installation Parameters: ");
		installParamsTxt = new JTextField(35);
		JButton installParamsHelpButton =
			helpButton(
				"DD file generation help: setting the installation parameters ",
				"If installing the content require any additional parameters, they should be specified here");
		JPanel installParamsPanel = new JPanel();
		installParamsPanel.add(installParamsLabel);
		installParamsPanel.add(installParamsTxt);
		installParamsPanel.add(installParamsHelpButton);
		panel.add(installParamsPanel);

		JLabel vendorLabel = new JLabel("Vendor: ");
		vendorTxt = new JTextField(35);
		JButton vendorHelpButton =
			helpButton(
				"DD file generation help: setting the vendor",
				"Give information about the content ptovider.");
		JPanel vendorPanel = new JPanel();
		vendorPanel.add(vendorLabel);
		vendorPanel.add(vendorTxt);
		vendorPanel.add(vendorHelpButton);
		panel.add(vendorPanel);
	}

	/**
	 * Add the forward lock options panel to the specified panel.
	 * @param panel	the destination panel.
	 */
	private void addDMPanel(JPanel panel) {
		JLabel dmLabel = new JLabel("Setting for forward lock publishing: ");
		panel.add(dmLabel);

		JCheckBox boundaryStringCB =
			new JCheckBox("Set manually the boundary string");
		boundaryStringTxt =
			new JTextField(MIMEType.generateRandomBoundaryString(), 35);
		boundaryStringTxt.setEnabled(false);
		boundaryStringCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (boundaryStringTxt.isEnabled()) {
					boundaryStringTxt.setEnabled(false);
					boundaryStringTxt.setText(
						MIMEType.generateRandomBoundaryString());
				} else {
					boundaryStringTxt.setEnabled(true);
				}
			}
		});
		JButton boundaryStringHelpButton = new JButton("?");
		boundaryStringHelpButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(
					null,
					"If not manually defined, the Boundary String will be a set to a random valid boudary string",
					"Help: setting the Boundary String",
					JOptionPane.INFORMATION_MESSAGE,
					null);
			}
		});
		ButtonGroup encoding = new ButtonGroup();
		JLabel encodingMsg = new JLabel("Select encoding method");
		binaryButton = new JRadioButton("Binary");
		binaryButton.setSelected(true);
		encoding.add(binaryButton);
		JRadioButton base64Button = new JRadioButton("Base64");
		encoding.add(base64Button);

		JButton encodingHelpButton = new JButton("?");
		encodingHelpButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(
					null,
					"Choose if the dm file will or not be Base 64 encoded",
					"Help: DM encoding format",
					JOptionPane.INFORMATION_MESSAGE,
					null);
			}
		});
		encodingHelpButton.setAlignmentY(JButton.RIGHT_ALIGNMENT);

		JLabel prefixMsg = new JLabel("Filename prefix: ");
		prefixPreviewMsg =
			new JLabel("Sample file name preview: " + "sample.dm");
		prefixTxt = new JTextField(35);
		prefixTxt.addCaretListener(new CaretListener() {
			public void caretUpdate(CaretEvent e) {
				prefixPreviewMsg.setText(
					"Sample file name preview: "
						+ prefixTxt.getText()
						+ "sample.dm");
			}
		});
		JPanel boundaryStringPanel = new JPanel();
		boundaryStringPanel.add(boundaryStringCB);
		boundaryStringPanel.add(boundaryStringTxt);
		boundaryStringPanel.add(boundaryStringHelpButton);
		panel.add(boundaryStringPanel);

		JPanel encodingPanel = new JPanel();
		encodingPanel.add(encodingMsg);
		encodingPanel.add(binaryButton);
		encodingPanel.add(base64Button);
		encodingPanel.add(encodingHelpButton);
		panel.add(encodingPanel);

		JPanel prefixPanel = new JPanel();
		prefixPanel.add(prefixMsg);
		prefixPanel.add(prefixTxt);
		panel.add(prefixPanel);
		prefixPreviewMsg.setHorizontalAlignment(JLabel.CENTER);
		panel.add(prefixPreviewMsg);
	}

	/**
	 * Build the main panel.
	 * @return	the main panel of the aplications.
	 */
	private JComponent makeMainPanel() {
		JPanel panel = new JPanel(false);
		panel.setLayout(new GridLayout(0, 1));

		JLabel filler = new JLabel("File selection and publishing settings");
		filler.setHorizontalAlignment(JLabel.CENTER);
		panel.add(filler);

		JLabel fileChooserLabel = new JLabel("File to publish: ");
		fileChooserTxt = new JTextField(35);
		JButton fileChooserButton = new JButton("Browse...");
		fileChooserButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				int returnVal = chooser.showOpenDialog(null);
				fileChooserTxt.setText(chooser.getSelectedFile().getPath());
			}
		});
		JPanel fileChooserPanel = new JPanel();
		fileChooserPanel.add(fileChooserLabel);
		fileChooserPanel.add(fileChooserTxt);
		fileChooserPanel.add(fileChooserButton);
		panel.add(fileChooserPanel);

		JLabel destinationChooserLabel = new JLabel("Destination directory: ");
		destinationChooserTxt = new JTextField(35);
		JButton destinationChooserButton = new JButton("Browse...");
		destinationChooserButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int returnVal =
					chooser.showDialog(null, "Select this directory");
				destinationChooserTxt.setText(
					chooser.getSelectedFile().getPath());
			}
		});
		JPanel destinationChooserPanel = new JPanel();
		destinationChooserPanel.add(destinationChooserLabel);
		destinationChooserPanel.add(destinationChooserTxt);
		destinationChooserPanel.add(destinationChooserButton);
		panel.add(destinationChooserPanel);

		forwardLockCB = new JCheckBox("Generate Forward Lock (.dm) file");
		forwardLockCB.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (forwardLockCB.isSelected()) {
					downloadDescriptorCB.setEnabled(true);
				} else {
					downloadDescriptorCB.setEnabled(false);
					downloadDescriptorCB.setSelected(false);
				}
			}
		});
		panel.add(forwardLockCB);

		downloadDescriptorCB =
			new JCheckBox("Generate Download Descriptor (.dd) file");
		downloadDescriptorCB.setEnabled(false);
		panel.add(downloadDescriptorCB);

		mmsGenerationCB =
			new JCheckBox("Generate MMS file (.mms) to send content");
		mmsGenerationCB.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (mmsGenerationCB.isSelected()) {
					mmsSendingCB.setEnabled(true);
				} else {
					mmsSendingCB.setEnabled(false);
					mmsSendingCB.setSelected(false);
				}
			}
		});
		JLabel mmsHowToLabel =
			new JLabel("If a dm file is generated, it is this file which will be MMS wrapped.");
		panel.add(mmsGenerationCB);
		panel.add(mmsHowToLabel);

		mmsSendingCB = new JCheckBox("Send the generated MMS File");
		mmsSendingCB.setEnabled(false);
		panel.add(mmsSendingCB);

		JButton proceedButton = new JButton("Perform requested operations");
		proceedButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Vector resultStackMessage = new Vector();
				boolean result =
					publish(
						new File(fileChooserTxt.getText()),
						forwardLockCB.isSelected(),
						downloadDescriptorCB.isSelected(),
						mmsGenerationCB.isSelected(),
						mmsSendingCB.isSelected(),
						resultStackMessage);

				popUpResultWindow(resultStackMessage, result);
				//System.out.println("DEBUG: " + result);
			}
		});
		JPanel proceedPanel = new JPanel();
		proceedPanel.add(proceedButton);
		panel.add(proceedPanel);

		return panel;
	}

	/**
	 * Pop up a window displaying result message.
	 * @param resultStackMessage	the stack of messages to be displayed.
	 * @param correctExecution	the operation execution result
	 */
	protected void popUpResultWindow(
		Vector resultStackMessage,
		boolean correctExecution) {
		String result = new String();
		Iterator it = resultStackMessage.iterator();
		while (it.hasNext()) {
			result += it.next();
		}
		JOptionPane.showMessageDialog(
			null,
			result,
			"Command Result",
			correctExecution
				? JOptionPane.INFORMATION_MESSAGE
				: JOptionPane.ERROR_MESSAGE);
	}

	/** Returns an ImageIcon, or null if the path was invalid. */
	protected static ImageIcon createImageIcon(String path) {
		java.net.URL imgURL = VisualPublisher.class.getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL);
		} else {
			//			System.err.println("Couldn't find file: " + path);
			return null;
		}
	}

	/**
	 * Create the GUI and show it.  For thread safety,
	 * this method should be invoked from the
	 * event-dispatching thread.
	 */
	private static void createAndShowGUI() {
		//Make sure we have nice window decorations.
		JFrame.setDefaultLookAndFeelDecorated(true);

		//Create and set up the window.
		JFrame frame = new JFrame("DRM and MMS publisher GUI");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		JComponent newContentPane = new VisualPublisher();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.getContentPane().add(new VisualPublisher(), BorderLayout.CENTER);

		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}

	/***
	 * Build the output files. Do the processing of the input arguments according to the filled field in the different panels and the user chosen options.
	 * @param toPublish	the file to be treated	
	 * @param generateDmFile	to ask for DM file generation
	 * @param generateDdFile	to generate a DD file in addition to the DM file
	 * @param generateMmsFile	to generate an MMS file
	 * @param mmsSending		to send the generated MMS
	 * @param messageStack		an I/O <code>Vector</code> were the different execution messages will be stored.
	 * @return	<true>if all the operations could be performed. Else, this method will return <code>false</code>.
	 */
	public boolean publish(
		File toPublish,
		boolean generateDmFile,
		boolean generateDdFile,
		boolean generateMmsFile,
		boolean mmsSending,
		Vector messageStack) {
		boolean nothing = true;
		boolean errorOccured = false;
		String path =
			destinationChooserTxt.getText().length() != 0
				? destinationChooserTxt.getText() + '\\'
				: "";
		if (generateDmFile) {
			DMFile dmOutput = null;
			try {
				nothing = false;
				dmOutput = new DMFile(toPublish);
				dmOutput.setBoundaryString(boundaryStringTxt.getText());
				dmOutput.setBinaryEncoding(binaryButton.isSelected());
				toPublish = dmOutput.generateDMFile(prefixTxt.getText(), path);
				messageStack.add("DM file generated \n");
			} catch (IOException e) {
				errorOccured = true;
				messageStack.add(
					"A problem Happened during the DMFileGeneration \n");
				if (generateDdFile) {
					messageStack.add("The dd File could not be generated");
					generateDdFile = false;
				}
			} catch (IndexOutOfBoundsException e2) {
				errorOccured = true;
				messageStack.add("Unable to proceed with the input file. \n");
				if (generateDdFile) {
					messageStack.add("The dd File could not be generated");
					generateDdFile = false;
				}
			}
			if (generateDdFile) {
				try {
					DDFile ddFile =
						new DDFile(toPublish, dmOutput.getContentType());
					if (nameTxt.getText().length() != 0) {
						ddFile.setName(nameTxt.getText());
					}
					if (descriptionTxt.getText().length() != 0) {
						ddFile.setDescription(descriptionTxt.getText());
					}
					if (installNotifyURLTxt.getText().length() != 0) {
						ddFile.setInstallNotifyURI(
							installNotifyURLTxt.getText());
					}
					if (nextURLTxt.getText().length() != 0) {
						ddFile.setNextUrl(nextURLTxt.getText());
					}
					if (infoURLTxt.getText().length() != 0) {
						ddFile.setInfoUrl(infoURLTxt.getText());
					}
					if (iconURLTxt.getText().length() != 0) {
						ddFile.setIconUrl(iconURLTxt.getText());
					}
					if (installParamsTxt.getText().length() != 0) {
						ddFile.setInstallNotifyURI(installParamsTxt.getText());
					}
					if (vendorTxt.getText().length() != 0) {
						ddFile.setVendor(vendorTxt.getText());
					}
					if (objectURITxt.getText().length() != 0) {
						ddFile.setObjectURI(objectURITxt.getText());
					}
					ddFile.generateDDFile(path);
					messageStack.add("DD file GENERATED \n");
				} catch (IOException e1) {
					errorOccured = true;
					e1.printStackTrace();
					messageStack.add(
						"An error occured during the ddFile generation. \n");
				}
			}
		}
		if (generateMmsFile) {
			nothing = false;
			try {
				String from = null, to = null, cc = null, bcc = null;
				if (fromTxt.getText().length() != 0) {
					try {
						from = MMSFile.formatAddress(fromTxt.getText());
					} catch (NonMMSAddressException e1) {
						errorOccured = true;
						messageStack.add(
							"The From address is not a valid MMS address. \n");
					}
				}
				if (toTxt.getText().length() != 0) {
					try {
						to = MMSFile.formatAddress(toTxt.getText());
					} catch (NonMMSAddressException e1) {
						errorOccured = true;
						messageStack.add(
							"The To address is not a valid MMS address. \n");
					}
				}
				if (ccTxt.getText().length() != 0) {
					try {
						cc = MMSFile.formatAddress(ccTxt.getText());
					} catch (NonMMSAddressException e1) {
						errorOccured = true;
						messageStack.add(
							"The Cc address is not a valid MMS address. \n");
					}
				}
				if (bccTxt.getText().length() != 0) {
					try {
						bcc = MMSFile.formatAddress(bccTxt.getText());
					} catch (NonMMSAddressException e1) {
						errorOccured = true;
						messageStack.add(
							"The Bcc address is not a valid MMS address. \n");
					}
				}
				MMSFile output = new MMSFile(from, to, cc, bcc);
				output.AddContent(toPublish);

				if (transactionIdTxt.getText().length() != 0) {
					output.setTransactionId(transactionIdTxt.getText());
				}
				if (subjectTxt.getText().length() != 0) {
					output.setSubject(subjectTxt.getText());
				}
				if (mmsFileNameTxt.getText().length() != 0) {
					output.setMmsFileName(mmsFileNameTxt.getText());
				}
				if (output.generateMMSFile(path) != null) {
					messageStack.add("MMS file GENERATED \n");
				} else {
					errorOccured = true;
					messageStack.add(
						"An error Occured during the MMS File generation. \n");
					if (mmsSending) {
						messageStack.add("No mms will be send. \n");
						mmsSending = false;
					}
				}
			} catch (IllegalArgumentException e) {
				errorOccured = true;
				messageStack.add(
					"An error occured during the MMS File generation: Incorrect Parameters \n");
				messageStack.add(e.getMessage() + '\n');
			}
			if (mmsSending) {
				messageStack.add(
					"Sorry, the MMS sending option is not yet avaible. \n");
			}
		}
		if (nothing) {
			errorOccured = true;
			messageStack.add("No actions have been selected!");
		}
		return !errorOccured;
	}

	JButton helpButton(final String helpTopic, final String helpMessage) {
		JButton toReturn = new JButton("?");
		toReturn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(
					null,
					helpMessage,
					helpTopic,
					JOptionPane.INFORMATION_MESSAGE,
					null);
			}
		});
		return toReturn;
	}
}
