package sg.edu.nyp.drmPublisher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Pierre Trocme
 */
public class Base64Codec {

	/**
	 * Convert a byte sequence into its Base64 encoded form.
	 * @param toConvert	The byte sequence to encode
	 * @return	the Base64 encoded form
	 */
	public static char[] encodeBase64(byte[] toConvert) {
		int nbBytes = toConvert.length;
		StringBuffer buffer = new StringBuffer();
		int addedCariage = 0;

		for (int i = 0; i < nbBytes; i += 3) {
			int currentLength = Math.min(3, nbBytes - i);
			byte[] currentBytes = new byte[currentLength];
			char[] currentChars;
			System.arraycopy(toConvert, i, currentBytes, 0, currentLength);
			buffer.append(encodeThreeBytes(currentBytes));
			if ((buffer.length() - addedCariage) % 76 == 0) {
				addedCariage++;
				buffer.append('\n');
			}
		}
		return buffer.toString().toCharArray();
	}
	
	/**
	 * Decode a base64 encoded cvhar array.
	 * @param toDecode	the char array to decode
	 * @return	the byte array of decoded datas
	 */
	public static byte[] decodeBase64(char[] toDecode) {
		if (toDecode.length % 4 != 0) {
			throw new IllegalArgumentException();
		}
		StringBuffer charBuffer = new StringBuffer();
		StringBuffer bytesBuffer = new StringBuffer();
		charBuffer.append(toDecode);

		Pattern p = Pattern.compile("[^a-zA-Z0-9\\+\\/=]");
				Matcher m = p.matcher(charBuffer.toString());
				charBuffer = new StringBuffer();
				while (m.find()) {
					m.appendReplacement(charBuffer, "");
				}
				m.appendTail(charBuffer);
		
		int nbChars = charBuffer.length();
		for (int i = 0; i < nbChars; i += 4) {
			char[] tmpChars = new char[4];
			charBuffer.getChars(i, i + 4, tmpChars, 0);

			bytesBuffer.append(new String(decodeFourChars(tmpChars)));
		}
		return bytesBuffer.toString().getBytes();
	}
	
	/**
	 * Base 64 encode three bytes.
	 * @param threeBytes	the three bytes to encode
	 * @return	four chars which represent the base64 encoded bytes.
	 */
	protected static char[] encodeThreeBytes(byte[] threeBytes) {
		int bitStream = 0;
		char[] toReturn = new char[4];
		int paddling = 0;
		if (threeBytes.length > 3) {
			throw new IllegalArgumentException();
		}

		if (threeBytes.length < 3) {
			int toPaddleSize = threeBytes.length;
			byte[] inputCopy = new byte[toPaddleSize];
			System.arraycopy(threeBytes, 0, inputCopy, 0, toPaddleSize);
			threeBytes = new byte[3];
			System.arraycopy(inputCopy, 0, threeBytes, 0, toPaddleSize);
			for (; toPaddleSize + paddling < 3; paddling++) {
				threeBytes[toPaddleSize + paddling] = 0x00;
			}
		}
		for (int i = 0; i <= 2; i++) {
			bitStream += threeBytes[i] << (8 * (2 - i));
		}
		for (int i = 3; i >= 0; i--) {
			toReturn[i] = encodeSixBits((byte) (bitStream & 0x3f));
			bitStream >>= 6;
		}

		while (paddling-- > 0) {
			toReturn[3 - paddling] = '=';
		}

		return toReturn;
	}

	/**
	 * Encode six bits.
	 * @param six	a byte containing the six bits to encode.
	 * @return	a char reprensenting the Base 64 encoded form of the input byte.
	 */
	protected static char encodeSixBits(byte six) {
		if ((six & 0xC0) != 0) {
			throw new IllegalArgumentException();
		}
		if (six < 26) {
			return (char) ('A' + six);
		}
		if (six < 52) {
			return (char) ('a' + (six - 26));
		}
		if (six < 62) {
			return (char) ('0' + (six - 52));
		}
		if (six == 62) {
			return '+';
		}
		return '/';
	}

	/**
	 * Decode four chars.
	 * @param toDecode	an array of four chars to decode
	 * @return	between 1 and 3 bytes reprensenting the Base 64 decoded form of the input char array.
	 */
	protected static byte[] decodeFourChars(char[] toDecode) {
		if (toDecode.length != 4) {
			throw new IllegalArgumentException();
		}
		int bitStream = 0;
		int paddling = 0;
		byte[] toReturn;
		for (int i = 3; i >= 0; i--) {
			if (toDecode[i] == '=') {
				paddling++;
			} else {
				break;
			}
		}
		if (paddling > 2) {
			throw new IllegalArgumentException();
		}
		toReturn = new byte[3 - paddling];
		for (int i = 0; i < 4; i++) {
			bitStream += (decodeSixBits(toDecode[i]) << (6 * (3 - i)));
		}
		bitStream >>= 8*paddling;
		for (int i = toReturn.length - 1; i >= 0; i--) {
			toReturn[i] = (byte) (bitStream & 0xff);
			bitStream >>= 8;
		}
		return toReturn;
	}

	/**
	 * Decode six bits.
	 * @param c	the char to decode
	 * @return	a byte containing the six bits Base 64 decoded form of the input.
	 */
	protected static byte decodeSixBits(char c) {
		if (c == '=') return 0;
		if (c >= 'A' && c <= 'Z') {
			return (byte) (c - 'A');
		}
		if (c >= 'a' && c <= 'z') {
			return (byte) (c - 'a' + 26);
		}
		if (c >= '0' && c <= '9') {
			return (byte) (c - '0' + 52);
		}
		if (c == '+') {
			return 62;
		};
		return 63;
	}
}
