package sg.edu.nyp.drmPublisher;
import java.io.File;
import java.util.HashMap;

/**
 * @author Pierre Trocme
 */
public class MIMEType {
	protected HashMap ex2Type;

	/**
	 * Create a new MIMEType object.
	 *
	 */
	public MIMEType() {
		ex2Type = new HashMap();
		initialize();
	}

	/**
	 * Return the MIME content type associated with the given file extension.
	 * @param fileExtension	the extension to be used for retrieving the file description
	 * @return	the MIME content type description
	 */
	public String getMIMEContentType(String fileExtension) {
		return (String) ex2Type.get(fileExtension);
	}

	/**
	 * Return the MIME content type associated with the given file.
	 * @param file	file whose type will be retrieved.
	 * @return	the MIME content type description.
	 */
	public String getMIMEContentType(File file) {
		String fileName = file.getName();
		String ext = fileName.substring(fileName.lastIndexOf('.')).substring(1);
		return getMIMEContentType(ext);
	}
	/**
	 * Initialize the table which will be used for retrieving the MIME type description.
	 *
	 */
	protected void initialize() {
		ex2Type.put("txt", "text/plain");
		ex2Type.put("htm", "text/html");
		ex2Type.put("html", "text/html");
		ex2Type.put("gif", "image/gif");
		ex2Type.put("jpg", "image/jpeg");
		ex2Type.put("wbmp", "image/vnd.wap.wbmp");
		ex2Type.put("png", "image/png");
		ex2Type.put("svg", "image/svg");
		ex2Type.put("svgz", "image/svg");
		ex2Type.put("ota", "image/x-ota-bitmap");
		ex2Type.put("bmp", "image/x-bmp");
		ex2Type.put("mbm", "image/x-epoc-mbm");
		ex2Type.put("tif", "image/tiff");
		ex2Type.put("tiff", "image/tiff");
		ex2Type.put("Ringtone", "application/vnd.nokia.ringing-tone");
		ex2Type.put("mel", "text/mel");
		ex2Type.put("emy", "text/x-emelody");
		ex2Type.put("imy", "text/x-imelody");
		ex2Type.put("amr", "audio/amr");
		ex2Type.put("evr", "audio/evrc");
		ex2Type.put("Smv", "audio/Smv");
		ex2Type.put("mid", "audio/x-midi");
		ex2Type.put("midi", "audio/x-midi");
		ex2Type.put("mmf", "application/x-smaf");
		ex2Type.put("wav", "audio/x-wav");
		ex2Type.put("mps", "audio/mps");
		ex2Type.put("wve", "audio/x-sibo");
		ex2Type.put("rmf", "audio/rmf");
		ex2Type.put("ra", "audio/x-pn-realaudio");
		ex2Type.put("ram", "audio/x-pn-realaudio");
		ex2Type.put("rm", "audio/x-pn-realaudio");
		ex2Type.put("rmp", "audio/x-pn-realaudio");
		ex2Type.put("au", "audio/basic");
		ex2Type.put("wma", "audio/x-ms-wma");
		ex2Type.put("qcp", "audio/qcp");
		ex2Type.put("avi", "video/avi");
		ex2Type.put("3gp", "video/3gp");
		ex2Type.put("mpeg", "video/mpeg");
		ex2Type.put("h263", "video/x-h263");
		ex2Type.put("qt", "video/quicktime");
		ex2Type.put("jar", "application/java-archive");
		ex2Type.put("jad", "text/vnd.sun.j2me.app-descriptor");
		ex2Type.put("dm", "application/vnd.oma.drm.message");
	}

	/**
	 * A filter for RFC2046 compliants bondaryStrings. The string is matched against <br>
	 * [a-zA-Z0-9'/()+_,-.:=?]+ <br>. 
	 * If its lenght is at least 1 and no more than 70, the string is considered as RFC2046 compliant.
	 * @param string	the string to test.
	 * @return	<code>true</code> if the string is a valid boudary string, else return <code>false</code>.
	 */
	public static boolean isValidBoundaryString(String string) {
		if (string.length() > 70) {
			return false;
		}
		return string.matches("[a-zA-Z0-9\'\\/()+_,-.:=?]+");
	}
	
	/**
	 * Generate a random MIME boundary String.
	 * @return the generated String.
	 */
	public static String generateRandomBoundaryString(){
		final String otherChars = "'/()+_,-.:=?";
		//[a-zA-Z0-9'/()+_,-.:=?]
		String toSet = new String();
		int length = (int) Math.ceil(Math.random() * 70);
		for (int i = 0; i < length; i++) {
			int toAdd = (int) (Math.random() * 74);
			if (toAdd < 26) {
				toSet += (char) ('a' + toAdd);
				continue;
			}
			if (toAdd < 52) {
				toSet += (char) ('A' + toAdd - 26);
				continue;
			}
			if (toAdd < 62) {
				toSet += (char) ('0' + toAdd - 52);
				continue;
			}
			toSet += otherChars.charAt(toAdd - 62);
		}
		if (!isValidBoundaryString(toSet.toString())) {
			System.out.println(
				"Unexpected error: an incorrect random boundary String has been generated.");
			System.out.println(toSet);
			return null;
		}
		return toSet.toString();
	}
}
