package sg.edu.nyp.drmPublisher.samples;
import java.io.File;
import java.io.IOException;

import sg.edu.nyp.drmPublisher.DDFile;
import sg.edu.nyp.drmPublisher.DMFile;
import sg.edu.nyp.drmPublisher.MMSFile;

/**
 * @author Pierre Trocme
 */
public class Publisher {

	/**
	 * The main method. Use a commad line interface (CLI) to allow the user to publish the files he want to.
	 * @param args	the user input arguments.
	 * @throws IOException	if an I/O error occurs.
	 */
	public static void main(String[] args) throws IOException {
		File toPublish;
		DMFile dmFile = null;
		DDFile ddFile = null;
		String prefix = "";
		String boundaryDelimiter = null;
		boolean binaryEncoding = true;
		boolean generateDDFile = false;
		String ddName = null;
		String ddDescription = null;
		String ddInstallNotifyURI = null;
		String ddNextURL = null;
		String ddInfoURL = null;
		String ddIconURL = null;
		String ddInstallParam = null;
		boolean generateMMSFile = false;
		String mmsFileName = null;
		String mmsTransactionID = null;
		String mmsFrom = null;
		String mmsTo = null;
		String mmsCc = null;
		String mmsBcc = null;
		String mmsSubject = null;

		if (args.length == 0) {
			System.out.println(
				"Usage : Publisher [-arg1 ... -argN] [-dd [-arg1 ... -argN]] [-mms -from -to [-arg1 ... argN]] file_To_Publish \n"
					+ "Options include: \n"
					+ "\t -boundary boudary	Set manually the boudary delimiter string. It will else be randomly generated \n"
					+ "\t -64				Base64 encoding of the dmFile \n"
					+ "\t -prefix prefix	Add the specified prefix to the dmFileName \n"
					+ "\t -dd	Generate the assotiated Download Descriptor file. \n"
					+ "\t -mms	Wrap the dm file in a mms-ready to be sended format \n"
					+ "Additionnal optionals arguments for the download Descriptor file include : \n"
					+ "\t -name name \n"
					+ "\t -description description \n"
					+ "\t -installNotifyURI installNotifyURI \n"
					+ "\t -nextURL nextURL \n"
					+ "\t -infoUrl infoUrl \n"
					+ "\t -iconUrl iconUrl \n"
					+ "\t -installParam installParam \n"
					+ "If the -mms option is used, the -from parameters and one of -to/-cc/-bcc must be used. Full parameters are : \n"
					+ "\t -mmsName mmsFileName	The name of the output MMS file. Will be set to file_to_publish.dm.mms by default \n"
					+ "\t -transactionID transactionID	The transactionID. Will be set to 012356789 by default \n"
					+ "\t -from from the sender phone number \n"
					+ "\t -to to	the recipient number \n"
					+ "\t -cc cc	the cc recipient \n"
					+ "\t -bcc bcc	the hiddent cc reciepient \n"	
					+ "\t -subject subject the subject of the mms \n" );
					
			System.exit(0);
		}

		int maxIndex = args.length - 1;
		toPublish = new File(args[maxIndex]);
		for (int i = 0; i < maxIndex; i++) {
			String toParse = args[i];
			if (toParse.equals("-64")) {
				binaryEncoding = false;
				continue;
			}
			if (toParse.equals("-prefix")) {
				i++;
				prefix += args[i];
				continue;
			}
			if (toParse.equals("-boundary")) {
				i++;
				boundaryDelimiter = args[i];
				continue;
			}

			if (toParse.equals("-dd")) {
				generateDDFile = true;
				continue;
			}

			if (toParse.equals("-mms")) {
				generateMMSFile = true;
				continue;
			}

			if (generateDDFile) {
				if (toParse.equals("-name")) {
					i++;
					ddName = args[i];
					continue;
				}
				if (toParse.equals("-description")) {
					i++;
					ddDescription = args[i];
					continue;
				}
				if (toParse.equals("-installNotifyURI")) {
					i++;
					ddInstallNotifyURI = args[i];
					continue;
				}
				if (toParse.equals("-nextURL")) {
					i++;
					ddNextURL = args[i];
					continue;
				}
				if (toParse.equals("-infoUrl")) {
					i++;
					ddInfoURL = args[i];
					continue;
				}
				if (toParse.equals("-iconUrl")) {
					i++;
					ddIconURL = args[i];
					continue;
				}
				if (toParse.equals("-installParam")) {
					i++;
					ddInstallParam = args[i];
					continue;
				}
			}
			if (generateMMSFile) {
				 if (toParse.equals("-mmsName")) {
					 i++;
					 mmsFileName = args[i];
					 continue;
				 }
				 
				 if (toParse.equals("-transactionID")) {
					i++;
					mmsTransactionID = args[i];
					continue;
				 }
				 
				 if (toParse.equals("-from")) {
					i++;
					mmsFrom = args[i];
					continue;
				 }
				 if (toParse.equals("-to")) {
					i++;
					mmsTo = args[i];
					continue;
				 }
				 if (toParse.equals("-cc")) {
					i++;
					mmsCc = args[i];
					continue;
				 }
				 if (toParse.equals("-bcc")) {
					i++;
					mmsBcc = args[i];
					continue;
				 }
				 if (toParse.equals("-subject")) {
					i++;
					mmsSubject = args[i];
					continue;
				 }
			}
			System.out.println("Unreconized command " + args[i]);
		}
		//DM,DD and MMS File generation
		dmFile = new DMFile(binaryEncoding, toPublish);
		if ((boundaryDelimiter != null)
			&& (!dmFile.setBoundaryString(boundaryDelimiter))) {
			System.out.println(
				"Incorrect boundary delimiter String: " + boundaryDelimiter);
		}
		File producedFile = dmFile.generateDMFile(prefix);
		System.out.println("DM file generated");

		if (generateDDFile) {
			ddFile = new DDFile(producedFile, dmFile.getContentType());
			if (ddName != null) {
				ddFile.setName(ddName);
			}
			if (ddDescription != null) {
				ddFile.setDescription(ddDescription);
			}
			if (ddInstallNotifyURI != null) {
				ddFile.setInstallNotifyURI(ddInstallNotifyURI);
			}
			if (ddNextURL != null) {
				ddFile.setNextUrl(ddNextURL);
			}
			if (ddInfoURL != null) {
				ddFile.setInfoUrl(ddInfoURL);
			}
			if (ddIconURL != null) {
				ddFile.setIconUrl(ddIconURL);
			}
			if (ddInstallParam != null) {
				ddFile.setInstallNotifyURI(ddInstallParam);
			}
			ddFile.generateDDFile();
			System.out.println("DD file GENERATED");
		}
		if(generateMMSFile){
			MMSFile output = new MMSFile(
				mmsFrom, 
				mmsTo, 
				mmsCc, 
				mmsBcc);
				if( mmsTransactionID != null){
					output.setTransactionId(mmsTransactionID);
				}
				if( mmsSubject != null) {
					output.setSubject(mmsSubject);
				} 
				if( mmsFileName != null ) {
					output.setMmsFileName(mmsFileName);
				} 
				output.generateMMSFile();
			System.out.println("MMS file GENERATED");
		}
	}
}
