package sg.edu.nyp.drmPublisher;
import java.io.*;
import java.util.Date;
import java.util.Vector;

import com.nokia.mms.*;
/**
 * Build a MMS message file to send a specified content.
 * @author Pierre Trocme
 */
public class MMSFile {
	protected String mmsFileName;
	protected MMMessage mms;

	/**
	 * Create a new MMSFile. At least one of the to/cc/bcc and from String should not be <code>null<code>.  
	 * @param from	the sender address, under a MMS form.
	 * @param to	the first reciepient address under a MMS form.
	 * @param cc	the first cc address under MMS form.
	 * @param bcc	the first bcc address under a MMS form.
	 * @see formatAddress
	 */
	public MMSFile(String from, String to, String cc, String bcc) {
		mms = new MMMessage();
		boolean isValid = false;

		//Just going to set the mandatories, and the subject...
		//Type,TransID,Version are all mandatory, and must be the first headers, in this order!
		mms.setMessageType(IMMConstants.MESSAGE_TYPE_M_SEND_REQ);
		mms.setTransactionId("0123456789");
		mms.setVersion(IMMConstants.MMS_VERSION_10);

		if (from == null) {
			throw new IllegalArgumentException("The from field is mandatory.");
		}
		mms.setFrom(from); //The user has to provide a full from.

		//at least one To/CC/BCC is mandatory
		if (to != null) {
			//				mms.addToAddress(to + "/TYPE=PLMN");
			mms.addToAddress(to);
			isValid = true;
		}

		if (cc != null) {
			mms.addCcAddress(cc /*+ "/TYPE=PLMN "*/
			);
			isValid = true;
		}

		if (bcc != null) {
			mms.addBccAddress(bcc /*+ "/TYPE=PLMN"*/
			);
			isValid = true;
		}

		if (!isValid) {
			throw new IllegalArgumentException("At least one of the fields To/Cc/Bcc is mandatory.");
		}

		mms.setContentType(IMMConstants.CT_APPLICATION_MULTIPART_MIXED);
		//Following tests, seems that this minimalist setting are enough
	}

//	public File generateMMSFile() {
//		MMEncoder encoder = new MMEncoder();
//		encoder.setMessage(mms);
//		try {
//			//3)Encode the message
//			encoder.encodeMessage();
//			byte[] out = encoder.getMessage();
//			//4)Print the encoded message to a file
//			return createMmsFile(
//				out,
//				(mmsFileName == null ? "TestMMS" : mmsFileName) + ".mms");
//		} catch (Exception e) {
//			System.out.println(e.getMessage());
//		}
//		return null;
//	}

	/**
	 * Generate the MMS File handelt by this MMSFile Object. The resulting file will be created in the execution directory.
	 * @return	The generated File
	 */
	public File generateMMSFile() {
		return generateMMSFile("");
	}


	/**
	 * Generate the MMS File handelt by this MMSFile Object.
	 * @param path	the destination directory
	 * @return	The generated File
	 */
	public File generateMMSFile(String path) {
		MMEncoder encoder = new MMEncoder();
		encoder.setMessage(mms);
		try {
			//3)Encode the message
			encoder.encodeMessage();
			byte[] out = encoder.getMessage();
			//4)Print the encoded message to a file
			return createMmsFile(
				out,
				path + 
				(mmsFileName == null ? "TestMMS" : mmsFileName) + ".mms");
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return null;
	}

	/**
	 * Add the specified file to the specified MMS message. The content Type is automaticaly resolved using the MIMEType class.
	 * @param m	the message in which will be ioncluded the content
	 * @param file	The File to be added
	 */
	public void AddContent(File file) {
		MMContent dmPart = new MMContent();
		byte[] b2 = readFile(file);
		dmPart.setContent(b2, 0, b2.length);
		dmPart.setContentId(file.getName());

		if (mmsFileName == null) {
			mmsFileName = file.getName();
		}
		//If "<>" are not used with this method, the result is Content-Location
		dmPart.setType(new MIMEType().getMIMEContentType(file));
		mms.addContent(dmPart);
	}

	/**
	 * Return a file under a binary form.
	 * @param file	The file to Read
	 * @return	the bytes it contains
	 */
	private byte[] readFile(File file) {
		int fileSize = 0;
		RandomAccessFile fileH = null;

		// Opens the file for reading.
		try {
			fileH = new RandomAccessFile(file, "r");
			fileSize = (int) fileH.length();
		} catch (IOException ioErr) {
			System.err.println("Cannot find " + file.getName());
			System.err.println(ioErr);
			System.exit(200);
		}

		// allocates the buffer large enough to hold entire file
		byte[] buf = new byte[fileSize];

		// reads all bytes of file
		int i = 0;
		try {
			while (true) {
				try {
					buf[i++] = fileH.readByte();
				} catch (EOFException e) {
					break;
				}
			}
		} catch (IOException ioErr) {
			System.out.println("ERROR in reading of file" + file);
		}

		return buf;
	}

	/**
	 * Create a new MMS file.
	 * @param output	the bytes to be written in this file
	 * @param filename	the name of the file to build
	 */
	private File createMmsFile(byte[] output, String filename) {
		try {
			//			String path = getPath();
			//			File f = new File(path + filename);
			File f = new File(filename);
			FileOutputStream out = new FileOutputStream(f);

			out.write(output);
			out.close();
			return f;
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return null;
	}
	/**
	 * @param arg0
	 */
	public void addBccAddress(String arg0) {
		mms.addBccAddress(arg0);
	}

	/**
	 * @param arg0
	 */
	public void addCcAddress(String arg0) {
		mms.addCcAddress(arg0);
	}

	/**
	 * @param arg0
	 */
	public void addToAddress(String arg0) {
		mms.addToAddress(arg0);
	}

	/**
	 * 
	 */
	public void clearBcc() {
		mms.clearBcc();
	}

	/**
	 * 
	 */
	public void clearCc() {
		mms.clearCc();
	}

	/**
	 * 
	 */
	public void clearTo() {
		mms.clearTo();
	}

	/**
	 * @return
	 */
	public Vector getBcc() {
		return mms.getBcc();
	}

	/**
	 * @return
	 */
	public Vector getCc() {
		return mms.getCc();
	}

	/**
	 * @param arg0
	 * @return
	 */
	public MMContent getContent(int arg0) {
		return mms.getContent(arg0);
	}

	/**
	 * @param arg0
	 * @return
	 */
	public MMContent getContent(String arg0) {
		return mms.getContent(arg0);
	}

	/**
	 * @return
	 */
	public String getContentType() {
		return mms.getContentType();
	}

	/**
	 * @return
	 */
	public Date getDate() {
		return mms.getDate();
	}

	/**
	 * @return
	 */
	public boolean getDeliveryReport() {
		return mms.getDeliveryReport();
	}

	/**
	 * @return
	 */
	public Date getDeliveryTime() {
		return mms.getDeliveryTime();
	}

	/**
	 * @return
	 */
	public Date getExpiry() {
		return mms.getExpiry();
	}

	/**
	 * @return
	 */
	public MMAddress getFrom() {
		return mms.getFrom();
	}

	/**
	 * @return
	 */
	public byte getMessageClass() {
		return mms.getMessageClass();
	}

	/**
	 * @return
	 */
	public String getMessageId() {
		return mms.getMessageId();
	}

	/**
	 * @return
	 */
	public byte getMessageStatus() {
		return mms.getMessageStatus();
	}

	/**
	 * @return
	 */
	public byte getMessageType() {
		return mms.getMessageType();
	}

	/**
	 * @return
	 */
	public String getMultipartRelatedType() {
		return mms.getMultipartRelatedType();
	}

	/**
	 * @return
	 */
	public int getNumContents() {
		return mms.getNumContents();
	}

	/**
	 * @return
	 */
	public MMContent getPresentation() {
		return mms.getPresentation();
	}

	/**
	 * @return
	 */
	public String getPresentationId() {
		return mms.getPresentationId();
	}

	/**
	 * @return
	 */
	public byte getPriority() {
		return mms.getPriority();
	}

	/**
	 * @return
	 */
	public boolean getReadReply() {
		return mms.getReadReply();
	}

	/**
	 * @return
	 */
	public byte getSenderVisibility() {
		return mms.getSenderVisibility();
	}

	/**
	 * @return
	 */
	public String getSubject() {
		return mms.getSubject();
	}

	/**
	 * @return
	 */
	public Vector getTo() {
		return mms.getTo();
	}

	/**
	 * @return
	 */
	public String getTransactionId() {
		return mms.getTransactionId();
	}

	/**
	 * @return
	 */
	public byte getVersion() {
		return mms.getVersion();
	}

	/**
	 * @return
	 */
	public String getVersionAsString() {
		return mms.getVersionAsString();
	}

	/**
	 * @return
	 */
	public boolean isBccAvailable() {
		return mms.isBccAvailable();
	}

	/**
	 * @return
	 */
	public boolean isCcAvailable() {
		return mms.isCcAvailable();
	}

	/**
	 * @return
	 */
	public boolean isContentTypeAvailable() {
		return mms.isContentTypeAvailable();
	}

	/**
	 * @return
	 */
	public boolean isDateAvailable() {
		return mms.isDateAvailable();
	}

	/**
	 * @return
	 */
	public boolean isDeliveryReportAvailable() {
		return mms.isDeliveryReportAvailable();
	}

	/**
	 * @return
	 */
	public boolean isDeliveryTimeAbsolute() {
		return mms.isDeliveryTimeAbsolute();
	}

	/**
	 * @return
	 */
	public boolean isDeliveryTimeAvailable() {
		return mms.isDeliveryTimeAvailable();
	}

	/**
	 * @return
	 */
	public boolean isExpiryAbsolute() {
		return mms.isExpiryAbsolute();
	}

	/**
	 * @return
	 */
	public boolean isExpiryAvailable() {
		return mms.isExpiryAvailable();
	}

	/**
	 * @return
	 */
	public boolean isFromAvailable() {
		return mms.isFromAvailable();
	}

	/**
	 * @return
	 */
	public boolean isMessageClassAvailable() {
		return mms.isMessageClassAvailable();
	}

	/**
	 * @return
	 */
	public boolean isMessageIdAvailable() {
		return mms.isMessageIdAvailable();
	}

	/**
	 * @return
	 */
	public boolean isMessageTypeAvailable() {
		return mms.isMessageTypeAvailable();
	}

	/**
	 * @return
	 */
	public boolean isPresentationAvailable() {
		return mms.isPresentationAvailable();
	}

	/**
	 * @return
	 */
	public boolean isPriorityAvailable() {
		return mms.isPriorityAvailable();
	}

	/**
	 * @return
	 */
	public boolean isReadReplyAvailable() {
		return mms.isReadReplyAvailable();
	}

	/**
	 * @return
	 */
	public boolean isSenderVisibilityAvailable() {
		return mms.isSenderVisibilityAvailable();
	}

	/**
	 * @return
	 */
	public boolean isStatusAvailable() {
		return mms.isStatusAvailable();
	}

	/**
	 * @return
	 */
	public boolean isSubjectAvailable() {
		return mms.isSubjectAvailable();
	}

	/**
	 * @return
	 */
	public boolean isToAvailable() {
		return mms.isToAvailable();
	}

	/**
	 * @return
	 */
	public boolean isTransactionIdAvailable() {
		return mms.isTransactionIdAvailable();
	}

	/**
	 * @return
	 */
	public boolean isVersionAvailable() {
		return mms.isVersionAvailable();
	}

	/**
	 * @param arg0
	 */
	public void setContentType(String arg0) {
		mms.setContentType(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setDate(Date arg0) {
		mms.setDate(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setDeliveryReport(boolean arg0) {
		mms.setDeliveryReport(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setDeliveryTime(Date arg0) {
		mms.setDeliveryTime(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setDeliveryTimeAbsolute(boolean arg0) {
		mms.setDeliveryTimeAbsolute(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setExpiry(Date arg0) {
		mms.setExpiry(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setExpiryAbsolute(boolean arg0) {
		mms.setExpiryAbsolute(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setFrom(String arg0) {
		mms.setFrom(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setMessageClass(byte arg0) {
		mms.setMessageClass(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setMessageId(String arg0) {
		mms.setMessageId(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setMessageStatus(byte arg0) {
		mms.setMessageStatus(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setMessageType(byte arg0) {
		mms.setMessageType(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setMultipartRelatedType(String arg0) {
		mms.setMultipartRelatedType(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setPresentationId(String arg0) {
		mms.setPresentationId(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setPriority(byte arg0) {
		mms.setPriority(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setReadReply(boolean arg0) {
		mms.setReadReply(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setSenderVisibility(byte arg0) {
		mms.setSenderVisibility(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setSubject(String arg0) {
		mms.setSubject(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setTransactionId(String arg0) {
		mms.setTransactionId(arg0);
	}

	/**
	 * @param arg0
	 */
	public void setVersion(byte arg0) {
		mms.setVersion(arg0);
	}

	/**
	 * @return
	 */
	public String getMmsFileName() {
		return mmsFileName;
	}

	/**
	 * @param string
	 */
	public void setMmsFileName(String string) {
		mmsFileName = string;
	}

	/**
	 * Format an address according to the MMS specifications. Email addresses and telephone numbers are accepted. 
	 * Email address should be conform to the RFC822 specification, and their validity is NOT tested by this method.
	 * Telephone number should be formated according to the ITU-T E.164 specification and start with the <code>+<code> international indicator. Any spaces or dot will be removed by this method. 
	 * @param currentAddress	the phone number or email address
	 * @return					the MMS formatted input address.
	 * @throws NonMMSAddressException	if the input address is not a reconized MMS address type.
	 */
	public static String formatAddress(String currentAddress)
		throws NonMMSAddressException {
		//Telephon number? i.e. +33 1 43 67 87 50
		if (currentAddress.startsWith("+")) {
			StringBuffer toReturn = new StringBuffer();
			toReturn.append('+');
			for (int i = 1, n = currentAddress.length(); i < n; i++) {
				char c = currentAddress.charAt(i);
				if (Character.isDigit(c)) {
					toReturn.append(c);
				}
			}
			toReturn.append("/TYPE=PLMN");
			return toReturn.toString();
		}
		//email address? i.e. me@home.net
		int atIndex = currentAddress.indexOf('@');
		if (atIndex > 0) {
			return new StringBuffer(currentAddress)
				.insert(atIndex, "/TYPE=RFC822")
				.toString();
		}
		//None of them? => bash!
		throw new NonMMSAddressException();
	}
}
