package sg.edu.nyp.drmPublisher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

/**
 * @author Pierre Trocme
 */
public class DDFile implements Serializable {
	String dmFileName;
	XmlElement media,
		size,
		objectURI,
		type,
		installNotifyURI,
		nextURL,
		name,
		description,
		vendor,
		infoUrl,
		iconUrl,
		installParam;
	Vector additionalMIMETypes;
	
	/**
	 * A field by field constructor designed for internal purpose only. <br>
	 * Please use DDFile(File DMFile, String contentType) instead. 
	 * @param objectURI the URI of the reffering DMFile
	 * @param size	the size of the DM file
	 * @param type	the MIME contentType of the DMFile content. 
	 */
	protected DDFile(String objectURI, long size, String type) {
		additionalMIMETypes = new Vector();
		media =
			new XmlElement(
				"media",
				"xmlns=\"http://www.openmobilealliance.org/xmlns/dd\"",
				null);
		this.objectURI = new XmlElement("objectURI", objectURI);
		this.size = new XmlElement("size", Long.toString(size));
		this.type = new XmlElement("type", type);
		addAContentType(new MIMEType().getMIMEContentType(new File(objectURI)));
	}
	/**
	 * Add an additional contentType the the description of the handled DM File.<br>
	 * @param string	The contentType to add
	 */
	private void addAContentType(String string) {
		additionalMIMETypes.add(new XmlElement("type", string));
	}
	
	public DDFile(File dmFile, String contentType) throws IOException {
		this(
			dmFile.getCanonicalPath(),
			dmFile.length(),
			contentType);
		dmFileName = dmFile.getName();
	}

	/**
	 * Build a .dd file describing the associated .dm file.<br>
	 * It is advised to use the more safe generateDDFile() method.
	 * @param path	the directory where will the DM File be created.
	 * @throws IOException	if an I/O Exception occurs
	 */
	public File generateDDFile(String path) throws IOException {
		String dmName = dmFileName;
		String ddName = dmName.substring(0, dmName.lastIndexOf('.')) + ".dd";
		File output = new File(path + ddName);

		FileWriter fw = new FileWriter(output);
		BufferedWriter out = new BufferedWriter(fw);
		out.write(this.toString());
		out.close();
		return output;
	}
	
	/**
	 * Generate the file described by this DDFile object. The file will be generated in the Execution directory 
	 * @throws IOException	if an I/O Exception occurs
	 */
	public File generateDDFile() throws IOException{
		return generateDDFile("");
	}


	/**
	 * Return a String view of this object. The string represents exactly the dd file which could result from using the generateDDFile(). 
	 */
	public String toString() {
		XmlElement mediaClone = (XmlElement) media.clone();
		mediaClone.add(objectURI);
		mediaClone.add(size);
		mediaClone.add(type);
		mediaClone.addAll(additionalMIMETypes);
		mediaClone.add(name);
		mediaClone.add(vendor);
		mediaClone.add(description);
		mediaClone.add(installNotifyURI);
		mediaClone.add(nextURL);
		mediaClone.add(infoUrl);
		mediaClone.add(iconUrl);		
		mediaClone.add(installParam);
		return mediaClone.toString();
	}
	/**
	 * Set the name tag.
	 * @param name	the name to set.
	 */
	public void setName(String name){
		this.name = new XmlElement("name", name);		
	}
	
	/**
	 * Set the Vendor tag
	 * @param vendor the vendor to set.
	 */
	public void setVendor(String vendor){
		this.vendor = new XmlElement("vendor", vendor);
	}
	
	/**
	 * Set the description tag.
	 * @param description the description to be set.
	 */
	public void setDescription(String description){
		this.description = new XmlElement("description", description);
	}
	
	/**
	 * Set the installNotifyURL tag.
	 * @param inURI	the installNotify string to be set.
	 */
	public void setInstallNotifyURI(String inURI){
		this.installNotifyURI = new XmlElement("installNotifyURI", inURI);
	}
	
	/**
	 * Set the nextURL tag.
	 * @param nextURL	the nextURL to be set.
	 */
	public void setNextUrl(String nextURL){
		this.nextURL = new XmlElement("nextURL", nextURL);
	}
	
	/**
	 * Set the infoURL tag.
	 * @param infoUrl	the infoURL to be set.
	 */
	public void setInfoUrl(String infoUrl){
		this.infoUrl = new XmlElement("infoURL", infoUrl);
	}
	
	/**
	 * Set the iconURL tag.
	 * @param iconUrl	the iconURL to set.
	 */
	public void setIconUrl(String iconUrl){
		this.iconUrl = new XmlElement(iconUrl);
	}
	
	/**
	 * Set the installParam tag
	 * @param installParam the installation parameters to set.
	 */
	public void setInstallParam(String installParam){
		this.installParam = new XmlElement("installParam", installParam);
	}
	
	/**
	 * Set the installParam tag. 
	 * This method is usefull only if the file publishing location is different from the current location.
	 * @param installParam the installation parameters to set.
	 */
	public void setObjectURI(String objectURI){
		this.objectURI = new XmlElement("ObjectURI", objectURI);
	}
	
	/**
	 * @author Pierre Trocme
	 */
	public class XmlElement implements Cloneable{
		private String argument;
		private String name;
		private Vector content;
	
		public String toString() {
			return '<'
				+ name
				+ ((argument != null) ? " " + argument : "")
				+ ((!content.isEmpty())
					? ">" + contentToString() + '<' + '/' + name + ">"
					: "/>");
		}
	
		/**
		 * Build an empty XML tag.
		 * @param name	the name of this tag
		 */
		public XmlElement(String name) {
			this.name = name;
			this.content = new Vector();
		}

		public XmlElement(String name, String argument, Object content) {
			this(name, content);
			setArgument(argument);		
		}
	
		public XmlElement(String name, Object initialContent){
			this(name);
			add(initialContent);
		}

		/**
		 * @param o
		 * @return
		 */
		public boolean add(Object o) {
			if(o != null){
				return content.add(o);
			} else {
				return false;
			}
		
		}

		/**
		 * @param o
		 * @return
		 */
		public boolean contains(Object o) {
			return content.contains(o);
		}

		/**
		 * @return
		 */
		public Iterator iterator() {
			return content.iterator();
		}

		/**
		 * @param o
		 * @return
		 */
		public boolean remove(XmlElement o) {
			return content.remove(o);
		}
	
		private String contentToString(){
			String toReturn = new String(); 
			Iterator it = content.iterator();
			if(content.isEmpty()){
				return toReturn;
			}
			if(content.size() == 1 ){
				toReturn += content.get(0);
			}else{
			while(it.hasNext()){
				toReturn += (char)0x0d; //<CR>
				toReturn += (char)0x0a; //<LF>
				toReturn += it.next();
			}
			toReturn += (char)0x0d; //<CR>
			toReturn += (char)0x0a; //<LF>
			}
			return toReturn;
		}
	

		/**
		 * @return
		 */
		public String getArgument() {
			return argument;
		}

		/**
		 * @param string
		 */
		public void setArgument(String string) {
			argument = string;
		}
	
		public Object clone(){
			XmlElement clone = new XmlElement(name);
			clone.setArgument(argument);
			clone.addAll(content);
			return clone;
		}
	
		/**
		 * @param c
		 * @return
		 */
		public boolean addAll(Collection c) {
			return content.addAll(c);
		}

	}

}
