/*
 Pon : an Opening Notepad
 Copyright (C) 2005 Pierre Trocm

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package pon;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * This class represent a Chapter, an element used for storing and organizing
 * the Notepad
 * 
 * @author Pierre Trocm
 * @version 0.4 - 1er Janvier 2005
 */
public class Chapitre extends DefaultChapitreMember implements Serializable {
    private static final long serialVersionUID = 1L;

    private Set<ChapitreMember> sousChapitres;

    /**
     * The basic constructor
     * 
     * @param name
     *            the title of the created Chapter.
     */
    public Chapitre(String name) {
        super(name);
        sousChapitres = new HashSet<ChapitreMember>();
    }

    /**
     * The deafault contructor. Create a new chapter which title is "Chapitre
     * sans nom".
     */
    public Chapitre() {
        this("Chapitre sans nom");
    }

    /**
     * @return the title of the Chapter
     */
    public String toString() {
        return getName();
    }

    /**
     * Add a new memeber to this chapter.
     * 
     * @param o
     *            the chapter member to add.
     * @return <code>true</code> if the chapter didnt contain this
     *         <code>ChapitreMember</code>, else <code>false</code>.
     */
    public boolean add(ChapitreMember o) {
        boolean toReturn = sousChapitres.add(o);
        if (toReturn) {
            o.setChapitre(this);
        }
        return toReturn;
    }

    /**
     * Remove a ChapterMember from this <code>Chapitre</code>.
     * 
     * @param toRemove
     *            the <code>ChapitreMember</code> to remove.
     * @return <code>true</code> if this <code>Chapitre</code> contained the
     *         specified element, else <code>false</code>.
     */
    public boolean remove(ChapitreMember toRemove) {
        boolean toReturn = sousChapitres.remove(toRemove);
        if (toReturn && toRemove.getChapitre() == this) {
            toRemove.setChapitre(null);
        }
        return toReturn;
    }

    /**
     * An Iterator over the content of this <code>Chapitre</code>.
     * 
     * @return an Iterator over the content of this <code>Chapitre</code>.
     */
    public Iterator<ChapitreMember> iterator() {
        return sousChapitres.iterator();
    }
}