/*
Pon : an Opening Notepad
Copyright (C) 2005 Pierre Trocm

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package pon;
/**
 * A chapterMember, which can contains other chapterMembers or pages.
 * @author Pierre Trocm
 * @version 0.1 - 24 dc. 2004
 */
public interface ChapitreMember extends Iterable<ChapitreMember>{
    
    /**
     * Give the title of this <code>ChapitreMember</code>.
     * @return the title.
     */
    public String getName();
    
    /**
     * Defines the title of this <code>ChapitreMember</code>.
     * @param name the title to set.
     */
    public void setName(String name);
    
    /**
     * Give the comments asociated withis <code>ChapitreMember</code>.
     * @return the comments.
     */
    public String getComments();
    
    /**
     * Set the comments asociated withis <code>ChapitreMember</code>.
     * @param comments the comments to set
     */
    public void setComments(String comments);

    /**
     * Set the chapter containing this element.
     * @param chapitre the containing <code>Chapitre</code>
     */
    public void setChapitre(Chapitre chapitre);

    /**
     * Get the chapter containing this element.
     * @return the chapitre this <code>ChapiterMember<code>.
     */
    public Chapitre getChapitre();
}
