/*
Pon : an Opening Notepad
Copyright (C) 2005 Pierre Trocm

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package pon;

import java.io.Serializable;

/**
 * Une clase grant un Maillon
 * @author Pierre Trocm
 * @version 0.2 - 23 dc. 2004
 */

public class Maillon implements Serializable{
    private static final long serialVersionUID = 1L;

    private String move;//Le coup en SAN

    private Page page;


    public Maillon(String move, Page page) {
        this.page = page;
        this.move = move;
    }

    public String getMove() {
        return move;
    }

    public Page getPage() {
        return page;
    }

    public String toString() {
        String toReturn = move + ", " + page.getName();
        return toReturn;
    }

    /**
     * @param currentPage
     */
    public void setPage(Page page) {
        this.page = page;
    }
}