package bbLib;
/**
 * Une classe Grant les blocages. Ne gre pas pour l'instant pas les
 * poursuites.
 * 29/05/04 : suppression du choix automatique de des, gestion des skills de base, et utilisation de l'interface de puchback
 * 01/06/04 : ajout de la possibilit de reRoller les des de combat et de  : CLAW, STRIP_BALL.
 * @author Pierre Trocm
 * @version 0.8 - 1er Juin 2004
 */
public class Blocage extends Action {
	public final static int ATTACKERDOWN = 1;
	public final static int BOTHDOWN = 2;
	public final static int DEFENDERDOWN = 3;
	public final static int DEFENDERDOWNER = 4;
	public final static int PUSHBACK = 5;
	private Joueur victime;
	private int attackerStrenght;
	private int defenderStrenght;
	private Field field;
	private int movedSquareBefore;
	/**
	 * Constructor for objects of class Blocage
	 */
	public Blocage(Joueur joueur, Joueur victime, int movedSquareBefore) throws IllegalActionException {
		super(Blocage, joueur);
		this.movedSquareBefore = movedSquareBefore;
		this.victime = victime;
		this.field = joueur.getField();
		if (field != victime.getField()) {
			throw new IllegalActionException();
		}
		
		attackerStrenght = joueur.getStrenght();
		defenderStrenght = victime.getStrenght(); 
		if( (attackerStrenght < defenderStrenght) &&(joueur.has("DAUNTLESS"))){
			Test dTest = new Test(defenderStrenght + 1, 2);
			if( Rules.test(dTest, "", joueur) ){
				attackerStrenght = defenderStrenght;
			}
		}
		if( joueur.has("HORNS")&&(movedSquareBefore > 0) ){
			attackerStrenght ++;
		}
		attackerStrenght += field.soutientContre(victime, joueur);
		defenderStrenght += field.soutientContre(joueur, victime);

		System.out.println(joueur + " Force = " + attackerStrenght);
		System.out.println(victime + " Force = " + defenderStrenght);
	}
	
	public Blocage(Joueur joueur, Joueur victime) throws IllegalActionException{
		this(joueur, victime, 0);
	}
	/**
	 * La mthode excute lors de la rsolution de l'action.
	 *  
	 */
	public void execute() throws TouchDownScoredException {
		if (!victime.isStanding()) {
			return;
		}

		int chosenDice;
		int nbDices = 1;
		int[] diceResults;
		if (Math.max(attackerStrenght, defenderStrenght) > Math.min(
				attackerStrenght, defenderStrenght)){
			System.out.println("+1D6");
			nbDices++;
		}
		if (Math.max(attackerStrenght, defenderStrenght) > 2 * Math.min(
				attackerStrenght, defenderStrenght)){
			System.out.println("+1D6");
			nbDices++;
		}
		System.out.println(nbDices + " Des pour ce blocage");

		diceResults = new int[nbDices];
		for (int i = 0; i < diceResults.length; i++) {
			diceResults[i] = Math.min(Dices.rollOneDice(), 5);
			System.out.println("diceResult[" + i + "] = " + diceResults[i]);
		}

//		chosenDice  = 0;
		if (attackerStrenght >= defenderStrenght) {
			chosenDice = joueur.choseDice(diceResults);
		}
		else {
			chosenDice = victime.choseDice(diceResults);
		}
		
		while( (chosenDice < 0) && (chosenDice > nbDices) ){
			if (attackerStrenght > defenderStrenght) {
				if(joueur.askForReRoll()){
					for (int i = 0; i < diceResults.length; i++) {
						diceResults[i] = Math.min(Dices.rollOneDice(), 5);
						System.out.println("diceResult[" + i + "] = " + diceResults[i]);
					}
					joueur.usedAReRoll();
				}
				chosenDice = joueur.choseDice(diceResults);
			}
			if (defenderStrenght > attackerStrenght) {
				if(victime.askForReRoll()){
					for (int i = 0; i < diceResults.length; i++) {
						diceResults[i] = Math.min(Dices.rollOneDice(), 5);
						System.out.println("diceResult[" + i + "] = " + diceResults[i]);
					}
					victime.usedAReRoll();
				}
				chosenDice = victime.choseDice(diceResults);
			}
		}
		try {
			switch (diceResults[chosenDice]) {
				case ATTACKERDOWN :
					attackerDown();
					break;
				case BOTHDOWN :
					bothDown();
					break;
				case DEFENDERDOWN :
					defenderDownAndPushedBack(true);
					break;
				case DEFENDERDOWNER :
					defenderDownAndPushedBack(false);
					break;
				case PUSHBACK :
					pushBack();
					break;
				default : System.out.println("This shouldnt happened, de choisi = " + diceResults[chosenDice]);
			}
		}
		catch (IllegalActionException iae) {
			System.out
					.println("Un probleme a eu lieu lors du traitement d'une blessure rsultant d'un blocage, IAE");
		}
	}
	
	private void attackerDown() throws IllegalActionException {
		Rules.fall(joueur, victime.has("CLAW")? 2:0);
	}
	private void pushBack() throws TouchDownScoredException {
		boolean followUp = joueur.askForFollowUp();
		try {
			if(Rules.push(joueur, victime, followUp, joueur) && victime.hasTheBall() && joueur.has("STRIP_BALL")){
				Rules.ballDrop(victime);
			}
		} catch (JoueurInconnuException jie) {
			System.out.println("erreur lors du repoussement : JIE");
		} catch (IllegalActionException iae) {
			System.out.println("erreur lors du repoussement : IAE");
		} catch (CaseNonVideException cnve) {
			System.out.println("erreur lors du repoussement : CNVE");
		} catch (CaseInexistanteException cie) {
			System.out.println("erreur lors du repoussement : CIE");
		}
	}
	
	private void defenderDownAndPushedBack(boolean canUseDodge) throws TouchDownScoredException {
		System.out.println("Defender down and pushed back!");
		boolean followUp = joueur.askForFollowUp();
		try {
			if (Rules.push(joueur, victime, followUp, joueur)){
				if(!canUseDodge || !victime.has("DODGE")){
					Rules.fall(victime, joueur.has("CLAW")? 2 : 0);
				}//Le eslse est lq cqr si le joueur tombe, il lache lq balle de toute maniere
				else if(victime.hasTheBall() && joueur.has("STRIP_BALL")){
					Rules.ballDrop(victime);
				}
			}
		} catch (JoueurInconnuException jie) {
			System.out.println("erreur lors du repoussement : JIE");
		} catch (IllegalActionException iae) {
			System.out.println("erreur lors du repoussement : IAE");
		} catch (CaseNonVideException cnve) {
			System.out.println("erreur lors du repoussement : CNVE");
		} catch (CaseInexistanteException cie) {
			System.out.println("erreur lors du repoussement : CIE");
		}
	}
	private void bothDown() throws IllegalActionException {
		System.out.println("Both down!");
		if(!joueur.has("BLOCK")){
			Rules.fall(joueur, victime.has("CLAW")? 2 : 0);
		}
		if(!victime.has("BLOCK")){
			Rules.fall(victime, joueur.has("CLAW")? 2 : 0);
		}
	}
	
	private void defenderDown() throws IllegalActionException {
		System.out.println("defender Down!");
		Rules.fall(victime, joueur.has("CLAW")? 2 : 0);
	}
}