package bbLib;

import java.util.HashSet;
import java.util.Iterator;
/**
 * Un endroit autre qu'une case ou peut se trouver un joueur(les vestiaire, les joueurs KO etc.).
 * 
 * @author Pierre Trocm
 * @version 0.3 - 9 Octobre 2003
 */

public class Box implements Emplacement
{
    private HashSet<Joueur> hashSet;
    private String name;
    public Box(String name){
        this.name = name;
        hashSet = new HashSet<Joueur>();
    }
    
     /**
     * Ajoute un joueur  cet emplacement
     * 
     * @param  joueur   le joueur  ajouter
     *
     **/
    public void add(Joueur joueur){
        hashSet.add(joueur);
    }
    
    /**
     * Ote un joueur de cet emplacement
     * 
     * @param  joueur   Le joueur  enlever.
     * @throws  IllegalActionException  Si le joueur ne se trouve pas dans cette case
     **/
    public void remove(Joueur joueur) throws IllegalActionException{
        if (hashSet.remove(joueur)) return;
        else throw new IllegalActionException();
    }
    /**
     * Une mthode Spcifie par Positionnable
     * 
     * @return -1 pour bien spcifier que cet lment n'appartient pas au terrain
     **/
    public int getX(){
        return -1;
    }

    /**
     * Une mthode Spcifie par Positionnable
     * 
     * @return -1 pour bien spcifier que cet lment n'appartient pas au terrain
     **/
    public int getY(){
        return -1;
    }
    
    public Iterator iterator(){
        return hashSet.iterator();
    }
    
    public String toString(){
        return name;
    }
}
