package bbLib;
import java.io.Serializable;
import java.util.StringTokenizer;
/**
 * Une classe decrivant les volutions possible d'un joueur.
 * 8 Septembre 2004 : ajout d'un serial version UID.
 * @author Pierre Trocm
 * @version 0.2 - 8 Septembre 2004
 */
public class CareerOpportunities implements Serializable{
	private static final long serialVersionUID = 5207800723907469544L;
	protected boolean general;
	protected boolean physical;
	protected boolean passing;
	protected boolean agility;
	protected boolean strenght;
	protected final String delimiter = ", ";
	public CareerOpportunities(String toParse) {
		StringTokenizer stringTokenizer = new StringTokenizer(toParse,
				delimiter);
		while (stringTokenizer.hasMoreElements()) {
			switch (stringTokenizer.nextToken().toUpperCase().charAt(0)) {
				case 'G' :
					general = true;
					break;
				case 'Y' :
					physical = true;
					break;
				case 'P' :
					passing = true;
					break;
				case 'S' :
					strenght = true;
					break;
				case 'A' :
					agility = true;
					break;
			}
		}
	}
	
	public String toString(){
		String toReturn = new String();
		if(general){
			toReturn += "G";
		}
		if(physical){
			if(toReturn.length() != 0){
				toReturn += ", ";
			}
			toReturn += "Y";
		}
		if(strenght){
			if(toReturn.length() != 0){
				toReturn += ", ";
			}

			toReturn += "S";
		}
		if(agility){
			if(toReturn.length() != 0){
				toReturn += ", ";
			}

			toReturn += "A";
		}
		if(passing){
			if(toReturn.length() != 0){
				toReturn += ", ";
			}
			toReturn += "P";
		}
		return toReturn;
	}
}