package bbLib;

/**
 * Gestion d'une Case du plateau.
 * 
 * @author Pierre Trocm
 * @version 0.3 - 24 Octobre 2003
 */
public class Case implements Positionable, Emplacement{
    private int x, y;
    private Joueur occupant;
    
    //Un contructeur de bas pour crer des cases vides
    public Case(){
    }
    
    public Case(int setx, int sety){
        x = setx;
        y = sety;
        occupant = null;
    }
    
    public Case(Positionable p){
        x = p.getX();
        y = p.getY();
        occupant = null;
    }
        
    public Case(int setx, int sety, Joueur j){
        x = setx;
        y = sety;
        occupant = j;
    }
    
    /**
     * Renseigne sur l'ventuelle occupation de la case.
     * 
     * @return <tt>true</tt> si la case est occupe, <t>false</tt> sinon.
     */
    public boolean isEmpty(){
        return occupant == null;
    }
    
    
    /**
     * Donne les coordonnes d'une case.
     * 
     * @return l'abcisse de la case
     */
    public int getX(){
        return x;
    }
    
    /**
     * Donne les coordonnes d'une case.
     * 
     * @return l'ordonne de la case
     */
    public int getY(){
        return y;
    }
    
    /**
     * Gere la sortie d'un joueur de cette case
     * 
     * @return Le joueur qui vient d'en sortir
     */
    public synchronized void remove(Joueur joueur) throws IllegalActionException{
        if(occupant != joueur) throw new IllegalActionException();
        occupant = null;
    }
    

    /**
     * Fait entrer un joueur dans une case.
     * 
     * @param j Le joueur qui entrera dans la case
     * @throw CaseNonVideException
     */
    public synchronized void add(Joueur j) throws CaseNonVideException{
        if ( !this.isEmpty() ) throw new CaseNonVideException();
       occupant = j;
    }
    
    /**
     * Renvoie une reprsentation sous forme de String de la case.
     * Le format est le suivant : "La case (x, y) est occupe par le Joueur occupant"
     * @return     the sum of x and y
     */
    public String toString()
    {
        return getX() +", "+ getY();
    }
    
    public Joueur getOccupant(){
        return occupant;
    }
}
