package bbLib;

import java.util.Iterator;

/**
 * Gestion de la partie. <br>
 * 19 Mai 2004 - Ajout de PlayingTeam et dispartion de methodes devenues
 * obsoletes.
 * 
 * @author Pierre Trocm
 * @version 0.9 - 19 Mai 2004
 */
public class ConcreteGameManager extends GameManager {
	private final int NBHALVES = 2;

	private final int NBTURNINHALVES = 8;

	private int half;

	private GameVariant gameVariant;

	//Variables dfinissant des attributs temporaires pour les quipes
	private PlayingTeam[] teams;

	private int gamePhase;

	private Field field;

	public final static int UNSTARTED = 0;

	public final static int T0TURN = 1;

	public final static int T1TURN = 2;

	public final static int T0PLACE = -1;

	public final static int T1PLACE = -2;

	public void kickOffInit(int kickingTeam) throws EndOfHalfException {
		//Sortir les joueurs du KO
		int requiredPlayers = gameVariant.getNbMaxPpalyersOnField();
		Joueur tmpJ;
		boolean blitz = false;
		boolean badKick = false;
		boolean goOn;
		int[] playersInReserve = new int[teams.length];
		Iterator it = field.kOIterator();
		PlayingTeam currentTeam;
		int currentTeamIndex;
		while (it.hasNext()) {
			tmpJ = (Joueur) it.next();
			if (new Test(4, 1).succeded())
				field.putInReserve(tmpJ);
		}
		it = field.reserveIterator();
		while (it.hasNext()) {
			Joueur tmpJoueur = (Joueur) it.next();
			for (int i = 0, n = teams.length; i < n; i++) {
				if (tmpJoueur.getTeam() == teams[i].getTeam()) {
					playersInReserve[i]++;
					continue;
				}
			}
		}
		field.goBackToLockers();
		for (int i = 0, n = teams.length; i < n; i++) {
			currentTeamIndex = (kickingTeam + i) % n;
			currentTeam = teams[currentTeamIndex];
			boolean leftSide = kickingTeam == 0;
			//POUR CHAQUE Equipe
			if (playersInReserve[currentTeamIndex] < gameVariant
					.getNbMinPlayersOnField()) {
				//GAME MANAGER : 3. Relire les regles et decider
			}
			placePlayers(currentTeam, leftSide);
		}
		goOn = true;
		do {
			try {
				//placer la balle sur le terrain
				field.placeBallAt(teams[kickingTeam].chooseTarget());
				goOn = false;
			} catch (CaseInexistanteException e) {
				//CONFORT dire au coach que sa case n'est pas valide
			}
		} while (goOn);
		switch (Dices.roll(2)) {
		case 2:
			int riotTime = Dices.rollOneDice();
			teams[0].moveTurnCounter(riotTime);
			teams[1].moveTurnCounter(riotTime);
			break;
		case 3:
			//GAME MANAGER : Get the ref
			//Aprs avoir defini la class referee
			break;
		case 4:
			placePlayers(teams[kickingTeam], kickingTeam == 0);
			break;
		case 5:
			goOn = true;
			int diff;
			do {
				diff = (Dices.rollOneDice() + teams[0].getFanFactor())
						- (Dices.rollOneDice() + teams[1].getFanFactor());
				if (diff > 0) {
					teams[0].addFreeReRoll();
					goOn = false;
					break;
				}
				if (diff < 0) {
					teams[1].addFreeReRoll();
					goOn = false;
					break;
				}
			} while (diff == 0);
			break;
		case 6:
			badKick = true;
			break;
		case 7:
			field.setWeather(Rules.weatherRoll());
			break;
		case 8:
			//GAME MANAGER : Quick snap!
			break;
		case 9:
			goOn = true;
			do {
				diff = (Dices.rollOneDice() + teams[0].getAssistantCoach())
						- (Dices.rollOneDice() + teams[1].getAssistantCoach());
				if (diff > 0) {
					teams[0].addFreeReRoll();
					goOn = false;
					break;
				}
				if (diff < 0) {
					teams[1].addFreeReRoll();
					goOn = false;
					break;
				}
			} while (diff == 0);
			break;
		case 10:
			blitz = true;
			break;
		case 11:
			//GAME MANAGER : Throw a Rock
			break;
		case 12:
			//GAME MANAGER : Field Invasion
			break;
		}
		//faire scatterer la balle
		boolean correctSquare = true;
		Positionable direction = Dices.ballBounceDirection();
		int xMod = direction.getX();
		int yMod = direction.getY();
		int xFrom, yFrom, scatterLength;
		scatterLength = Dices.roll(badKick ? 2 : 1);
		xFrom = field.getBallPosition().getX();
		yFrom = field.getBallPosition().getY();
		try {
			if (field.placeBallAt(xFrom + xMod * scatterLength, yFrom + yMod
					* scatterLength)) {
				if (!Rules.catchTest(
						field.getJoueurAt(field.getBallPosition()), false)) {
					Rules.ballBounceUntilStopped(field);
				}
			} else {
				Rules.ballBounceUntilStopped(field);
				//NON FINI : si la bale sort du terrain, elle ne revient pas
			}
		} catch (CaseInexistanteException e) {
			//CONFORT informer les joueurs que la balle est sortie du
			// terrain
			correctSquare = false;
			e.printStackTrace();
		}
		//verifier que la balle a le doit d'atterir ou elle a
		// atteri, i.e. la bonne moiti du terrain
		if (kickingTeam == 0) {
			Positionable ballPos = field.getBallPosition();
			correctSquare &= (ballPos.getX() <= gameVariant.fieldXScrimmageLine);
		} else {
			Positionable ballPos = field.getBallPosition();
			correctSquare &= (ballPos.getX() >= gameVariant.getFieldHalfXSIZE()
					+ gameVariant.getFieldXScrimmageLine());
		}
		if (!correctSquare) {
			boolean pasOk = true;
			do {
				try {
					field.placeBallAt(teams[(kickingTeam + 1) % 2]
							.choosePlayer());
					pasOk = false;
				} catch (CaseInexistanteException e) {
					e.printStackTrace();
				}
			} while (pasOk);
		}
		//Puis on y va
		//GAME MANAGER : prendre en compte le booleen blitz
	}

	/**
	 * @param currentTeam
	 */
	private void placePlayers(PlayingTeam currentTeam,
			boolean leftSideOfTheField) {
		boolean goOn = true;
		do {
			boolean correctFormation = true;
			//4. Demander au coach de placer ses joueurs
			String[] placements = currentTeam.placePlayers().split(";");
			if (placements.length > gameVariant.getNbMaxPlayersOnField()) {
				continue;
			}
			//5. Tenter de les placer
			try {
				for (int j = 0, m = placements.length; j < m; j++) {
					String[] toParse = placements[j].split(":");
					Joueur tmpJ = currentTeam.getJoueur(Integer
							.parseInt(toParse[0]));
					int destX = Integer.parseInt(toParse[1]);
					int destY = Integer.parseInt(toParse[2]);
					field.placeJoueurAt(tmpJ, destX, destY);
				}
			} catch (Exception e) {
				//CONFORT prevenir le coach que sa formation n'est pas
				// valide
				continue;
			}
			//GAME MANAGER : 6. Chercher les joueurs sur les lignes d'en
			// but et dans les zones laterales
			if (!correctFormation) {
				//CONFORT Dire au coach qu'il fait n'importe quoi
				continue;
			}
			goOn = false;
		} while (goOn);
	}

	private void gameEnd() {
		//GAME MANAGER crire le game end
	}

	private void gameStart() {
		int kickingTeam = (int) (Math.random() * 2);
		field.setWeather(Rules.weatherRoll());
		try {
			kickOffInit(kickingTeam);
		} catch (EndOfHalfException e) {
			// GAME MANAGER : passer a a la deuxieme mi-temps
			e.printStackTrace();
		}
	}

	public void touchDownScored(Joueur joueur) throws TouchDownScoredException,
			TeamInconnueException {
		int team = joueur2TeamIndex(joueur);
		teams[team].scoredTouchDown();
		System.out.println("un touchDown a t marqu par " + joueur);
		if (field.getWeather() == Rules.HEAT) {
			//GAME MANAGER : finir la gestion du climat (HEAT)
			//Noter les joueurs qui collapsent
		}
		//sortir tout les joueurs du terrain
		field.goBackToLockers();
		//changer de phase de jeu
		switch (team) {
		case 0:
			gamePhase = T0PLACE;
			break;
		case 1:
			gamePhase = T1PLACE;
			break;
		default:
			throw new TeamInconnueException();
		}
		joueur.turnOverHappened();
		throw new TouchDownScoredException();
	}

	/**
	 * Une fonction renseignant sur l'indice de l'quipe a laquelle appartient
	 * un joueur.
	 * 
	 * @param joueur
	 *            le joueur connu
	 * @return l'index de son quipe
	 * @throws equipeInconnueException
	 *             si l'quipe est introuvable
	 */
	private int joueur2TeamIndex(Joueur joueur) throws TeamInconnueException {
		return team2TeamIndex(joueur.getTeam());
	}

	private int team2TeamIndex(Team team) throws TeamInconnueException {
		for (int i = 0; i < 2; i++)
			if (team == teams[i])
				return i;
		throw new TeamInconnueException();
	}

	/**
	 * Gere un tour.
	 * 
	 * @param playingteam
	 *            l'equipe qui doit jouer ce tour
	 */
	protected void startTurn(PlayingTeam playingTeam) throws EndOfHalfException {
		boolean goOn = true;
		playingTeam.resetTurn();
		playingTeam.moveTurnCounter();
		//GAME MANAGER Finir startTurn
		while (playingTeam.nbOfAvailablePlayers() > 0) {
			Joueur tmpJoueur;
			Positionable target;
			int action;
			//3. Demander quel joueur doit jouer
			try {
				tmpJoueur = playingTeam.choseNextPlayer();
			} catch (NoMorePlayersException e) {
				//This shoudnt happened!
				e.printStackTrace();
				break;
			}
			//4. Demander quelle action doit etre entreprise
			action = playingTeam.chooseAction();
			//TANT QUE le joueur ne subit pas de turnOver personnel
			while (!playingTeam.isTurnOverForPlayer()) {
				//FAIRE
				//5. Demander sa cible
				target = playingTeam.chooseTarget();
				//GAME MANAGER : 5b. Verifier la pertinence de l'action
				//GAME MANAGER : 5c. SINON retourner en 4 (do/while)
				//GAME MANAGER : 6. SI elle peut etre executee,
				//GAME MANAGER : 7. ALORS l'executer
				//GAME MANAGER : prendre en compte le blitz sous ses deux
				// formes
				try {
					switch (action) {
					case Action.Deplacement:
						break;
					case Action.Blocage:
						break;
					case Action.Pietinement:
						break;
					case Action.Sprint:
						break;
					default:
						throw new IllegalActionException();
					}
				} catch (IllegalActionException e) {
					continue;
				}
				/*
				 * CONFORT : simplifier l'interface utilisateur Idee: ne pas
				 * demander le type d'action, decider en fonction de la cible.
				 * On sprinte lorsque on n'a plus de mvt, etc... Detail : Si au
				 * cun joueur n'est selectionne uu joueur de l'equipe -> uue
				 * selection SI un jouer est selectionne Ce joueur ->
				 * deselection Un joueur de l'equipe -> Passe Un joueur de
				 * l'equipe -> Passe/HandOff Un joueur de l'equipe adverse en
				 * contact debout -> block /Blitz A terre -> foul Sinon
				 * Impossible de detecte l'action. On peut poser la question en
				 * cas d'ambiguit, resoudre automatiquement sinon
				 */
				//GAME MANAGER : SINON Prevenir le coach
				//GAME MANAGER : Retourner en 3.
				if (playingTeam.isTurnOver()) {
					break;
				}
			}
			//FIN TANT QUE
			playingTeam.hasPlayed(tmpJoueur);
		}
	}

	//-------------------------------------------------------------------//
	public class PlayingTeam implements MessagingChain, InterceptionHandler {
		int turnCounter;

		int nbTouchDown;

		Roster roster;

		CoachMessenger coachMessenger;

		boolean usedAReRollThisTurn, turnOver, turnOverForPlayer;

		VectorSet availablePlayers;

		int freeReRolls = 0;

		public void resetTurn() {
			usedAReRollThisTurn = false;
			turnOver = false;
			Iterator it = roster.iterator();
			while (it.hasNext()) {
				Joueur tmpJoueur = (Joueur) it.next();
				if (!field.exist(tmpJoueur)) {
					continue;
				}
				tmpJoueur.resetTurn();
				availablePlayers.add(tmpJoueur);
			}
		}

		/**
		 *  
		 */
		public void scoredTouchDown() {
			nbTouchDown++;
		}

		/**
		 *  
		 */
		public void addFreeReRoll() {
			freeReRolls++;
		}

		/**
		 * @param tmpJoueur
		 */
		public void hasPlayed(Joueur joueur) {
			availablePlayers.remove(joueur);
			setTurnOverForPlayer(true);
		}

		public Joueur choseNextPlayer() throws NoMorePlayersException {
			if (availablePlayers.isEmpty()) {
				throw new NoMorePlayersException();
			}
			Joueur tmpJoueur;
			do {
				tmpJoueur = roster.getJoueur(coachMessenger
						.choosePlayerNumber());
			} while (!availablePlayers.contains(tmpJoueur));
			setTurnOverForPlayer(false);
			return tmpJoueur;
		}

		//GAME MANAGER : un truc pour gerer les fins de tours pour les joueurs
		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.MessagingChain#askForReRoll()
		 */
		public boolean askForReRoll() {
			return !usedAReRollThisTurn;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.MessagingChain#usedAReRoll()
		 */
		public void usedAReRoll() {
			usedAReRollThisTurn = true;
			coachMessenger.usedAReRoll();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.MessagingChain#askForFollowUp()
		 */
		public boolean askForFollowUp() {
			return coachMessenger.askForFollowUp();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.MessagingChain#choseASquare(bbLib.Positionable[])
		 */
		public int choseASquare(Positionable[] choices) {
			return coachMessenger.choseASquare(choices);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.MessagingChain#turnOverHappened()
		 */
		public void turnOverHappened() {
			turnOver = true;
			coachMessenger.turnOverHappened();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.MessagingChain#choseDice(int[])
		 */
		public int choseDice(int[] dicesResult) {
			return coachMessenger.choseDice(dicesResult);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.MessagingChain#useSkill(java.lang.String)
		 */
		public boolean useSkill(String skill) {
			return coachMessenger.useSkill(skill);
			//GAME MANAGER a quelle moment de la chaine regarde t-on si l'on
			// peut utiliser (i.e. fois par tour)
		}

		/**
		 * @param roster
		 * @param coachMessenger
		 */
		public PlayingTeam(Roster roster, CoachMessenger coachMessenger) {
			this.roster = roster;
			roster.setNextMessageHandler(this);
			this.coachMessenger = coachMessenger;
			usedAReRollThisTurn = false;
		}
		
		/**
		 * @return
		 */
		public int chooseAction() {
			return coachMessenger.chooseAction();
		}

		/**
		 * @return
		 */
		public Positionable choosePlayer() {
			return coachMessenger.choosePlayer();
		}

		/**
		 * @return
		 */
		public int choosePlayerNumber() {
			return coachMessenger.choosePlayerNumber();
		}

		/**
		 * @return
		 */
		public Positionable chooseTarget() {
			return coachMessenger.chooseTarget();
		}

		/**
		 * @return
		 */
		public String placePlayers() {
			return coachMessenger.placePlayers();
		}

		/**
		 * @param toTell
		 */
		public void tell(String toTell) {
			coachMessenger.tell(toTell);
		}

		/**
		 * @return Returns the turnOver.
		 */
		public boolean isTurnOver() {
			return turnOver;
		}

		/**
		 * @return the number of avaible players
		 */
		public int nbOfAvailablePlayers() {
			return availablePlayers.size();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.InterceptionHandler#askForInterception(bbLib.Joueur[])
		 */
		public int askForInterception(Joueur[] candidats) {
			return coachMessenger.askForInterception(candidats);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see bbLib.InterceptionHandler#ballHasBeenIntercepted(bbLib.Joueur)
		 */
		public void ballHasBeenIntercepted(Joueur joueur) {
			coachMessenger.ballHasBeenIntercepted(joueur);
		}

		/**
		 * @return Returns the roster.
		 */
		public Team getTeam() {
			return roster;
		}

		/**
		 * Donne un joueur de l'equipe depuis son numero.
		 * 
		 * @param i
		 *            Le numero du joueur
		 * @return Le joueur portqnt ce numero
		 */
		public Joueur getJoueur(int i) {
			return roster.getJoueur(i);
		}

		/**
		 * @return Returns the availablePlayers.
		 */
		public VectorSet getAvailablePlayers() {
			return availablePlayers;
		}

		/**
		 * @param availablePlayers
		 *            The availablePlayers to set.
		 */
		public void setAvailablePlayers(VectorSet availablePlayers) {
			this.availablePlayers = availablePlayers;
		}

		/**
		 * @return Returns the turnOverForPlayer.
		 */
		public boolean isTurnOverForPlayer() {
			return turnOverForPlayer;
		}

		/**
		 * @param turnOverForPlayer
		 *            The turnOverForPlayer to set.
		 */
		public void setTurnOverForPlayer(boolean toSet) {
			this.turnOverForPlayer = toSet;
		}

		/**
		 * @return
		 */
		public int getAssistantCoach() {
			return roster.getAssistantCoach();
		}

		/**
		 * @return
		 */
		public int getCheerleaders() {
			return roster.getCheerleaders();
		}

		/**
		 * @return
		 */
		public int getFanFactor() {
			return roster.getFanFactor();
		}

		/**
		 * Deplace le compteur de tours.
		 * 
		 * @param nbTurns
		 *            Le nombre de tour a avancer.
		 * @return Le nombre de tours ecouls pour cette equipe.
		 */
		public int moveTurnCounter(int nbTurns) throws EndOfHalfException {
			if (gameVariant.getHalfTime() == turnCounter) {
				throw new EndOfHalfException();
			}
			return turnCounter += nbTurns;
		}

		/**
		 * Deplace le compteur de tour d'un tour.
		 * 
		 * @return Le nombre de tours ecouls pour cette equipe.
		 */
		public int moveTurnCounter() throws EndOfHalfException {
			return moveTurnCounter(1);
		}
	}

	class NoMorePlayersException extends Exception {

		private static final long serialVersionUID = -1171189039310376206L;
	}
}
//NON FINI lorsqu'un joueurest repouss dans une case contenant la balle, lle
// scatter (a vrifier avec les regles)
//MISE EN FORME Commenter
//GAME MANAGER ecrire un constructeur