package bbLib;


/**
 * Une interface que se devra d'implmenter tout endroit ou peut se trouver un joueur
 * 
 * @author Pierre Trocm
 * @version 0.2 - 24 Octobre 2003
 */

public interface Emplacement extends Positionable
{
    /**
     * Ajoute un joueur  cet emplacement
     * 
     * @param  joueur   le joueur  ajouter
     * @throws CaseNonVideException Si il est impossibe d'entrer dans l'emplacement
     *
     **/
    public void add(Joueur joueur) throws CaseNonVideException;    
    
     /**
     * Ote un joueur de cet emplacement
     * 
     * @param  joueur   Le joueur  enlever.
     * @throws  IllegalActionException  Si le joueur ne se trouve pas dans cette case
     **/
    public void remove(Joueur joueur)throws IllegalActionException;
}
