package bbLib;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
/**
 * Une classe gerant le terrain. le terrain est vu "de profil" c'est a dire, que
 * les X max-1 et min designent les zones de Touchdown <br>
 * 19/05/04 - ajout de la methode ball bounce <br>
 * 30/05/04 - transfert de la methode ballDrop() dans Rules <br>
 * 
 * @author Pi
 * @version 0.3 - 30 Mai 2004
 *  
 */
public class Field {
	private final int halfXSIZE, YSIZE;
	private Case[][] terrain;
	private Positionable balle;
	protected Team iGotMyEyeOnYou;
	//NON FINI crer une classe Referee reprsentant l'arbitre.
	private Hashtable<Joueur, Emplacement> localisateur;
	//Une HashTable ou les joueurs servent d'index a des emplacements
	private Box reserve, kO, dAndI;
	protected short weather;
	private int yLateralZone;
	private int xScrimmageLine;
	
	/**
	 * @deprecated @param
	 *             XSIZE
	 * @param YSIZE
	 */
	public Field(int XSIZE, int YSIZE) {
		if (XSIZE % 2 != 0) {
			throw new IllegalArgumentException();
		}
		this.halfXSIZE = XSIZE / 2;
		this.YSIZE = YSIZE;
		terrain = new Case[XSIZE][YSIZE];
		for (int i = 0; i < XSIZE; i++)
			for (int j = 0; j < YSIZE; j++)
				terrain[i][j] = new Case(i, j);
		localisateur = new Hashtable<Joueur, Emplacement>();
		reserve = new Box("Reserve");
		kO = new Box("K.O.");
		dAndI = new Box("Dead and Injured");
	}
	/**
	 * Un constructeur.
	 * 
	 * @param HalfXSIZE
	 *            La moitie du trrain, le terrain est considere comme etant
	 *            symetrique par rapprt au milieu de l'axe des x.
	 * @param YSIZE
	 *            La largeur du terrain
	 * @param yLateralZone
	 *            La derniere ligne a etre dans la zone laterale.
	 */
	public Field(int HalfXSIZE, int YSIZE, int yLateralZone, int xScrimmageLine) {
		this.halfXSIZE = HalfXSIZE;
		this.YSIZE = YSIZE;
		terrain = new Case[HalfXSIZE * 2][YSIZE];
		for (int i = 0; i < HalfXSIZE * 2; i++)
			for (int j = 0; j < YSIZE; j++)
				terrain[i][j] = new Case(i, j);
		localisateur = new Hashtable<Joueur, Emplacement>();
		reserve = new Box("Reserve");
		kO = new Box("K.O.");
		dAndI = new Box("Dead and Injured");
		this.yLateralZone = yLateralZone;
		this.xScrimmageLine = xScrimmageLine;
		//TODO Supprimer la redondance des constructeurs (lequelq pelle l'autre?).
	}
	/**
	 * @param gameVariant
	 *            Construit un field en fonction d'un variante de jeu predefinie
	 */
	public Field(GameVariant gameVariant) {
		this(gameVariant.getFieldHalfXSIZE(), gameVariant.getFieldYSIZE(),
				gameVariant.getFieldYLateralZone(), gameVariant
						.getFieldXScrimmageLine());
	}
	private int xTouchDown(int team) throws TeamInconnueException {
		if (team == 0)
			return 0;
		if (team == 1)
			return terrain.length - 1;
		throw new TeamInconnueException();
	}
	/**
	 * Retourne une case de ce terrain  aprtir de ses coordonnes.
	 *
	 * @param  x l'abcisse de la case.
	 * @param  y l'ordonne de la case.
	 * @throw   CaseInexistanteException
	 */
	public Case getCase(int x, int y) throws CaseInexistanteException {
		try {
			return terrain[x][y];
		} catch (ArrayIndexOutOfBoundsException aioobe) {
			throw new CaseInexistanteException(x, y);
		}
	}
	/**
	 * Retourne une case de ce terrain  aprtir de ses coordonnes.
	 *
	 * @param  x l'abcisse de la case.
	 * @param  y l'ordonne de la case.
	 * @throw   CaseInexistanteException
	 */
	public Case getCase(Positionable c) throws CaseInexistanteException {
		return getCase(c.getX(), c.getY());
	}
	public void putInKO(Joueur joueur) throws JoueurInconnuException,
			IllegalActionException {
		if (!contains(joueur))
			throw new JoueurInconnuException();
		try {
			placeJoueurAt(joueur, kO);
		} catch (Exception e) {
			System.out.println("Une erreur a eu lieu lors de la mise K.O. de"
					+ joueur);
		}
	}
	public void putIndAndI(Joueur joueur) throws JoueurInconnuException,
			IllegalActionException {
		if (!contains(joueur))
			throw new JoueurInconnuException();
		try {
			placeJoueurAt(joueur, dAndI);
		} catch (Exception e) {
			System.out.println("Une erreur a eu lieu lors de la mort de"
					+ joueur);
		}
	}
	public void placeJoueurAt(Joueur joueur, int x, int y)
			throws JoueurInconnuException, IllegalActionException,
			CaseNonVideException, CaseInexistanteException {
		placeJoueurAt(joueur, getCase(x, y));
	}
	/**
	 * Place un joueur sur une case.
	 * 
	 * @param joueur
	 *            Le joueur a placer
	 * @param destination
	 *            L'emplacement ou mettre le joueur
	 * @return <tt>true</tt> si la balle se trouve sur cette case,
	 *         <tt>false</tt> false;
	 */
	public synchronized boolean placeJoueurAt(Joueur joueur,
			Emplacement destination) throws JoueurInconnuException,
			IllegalActionException, CaseNonVideException {
		if (localiser(joueur) == destination)
			return false;
		Emplacement provenance;
		provenance = (Emplacement) localisateur.put(joueur, destination);
		provenance.remove(joueur);
		destination.add(joueur);
		if (balle == destination)
			return true;
		return false;
	}
	public boolean contains(Joueur joueur) {
		return localisateur.containsKey(joueur);
	}
	public Emplacement localiser(Joueur joueur) throws JoueurInconnuException {
		if (!contains(joueur))
			throw new JoueurInconnuException();
		return (Emplacement) (localisateur.get(joueur));
	}
	public void addJoueur(Joueur joueur) {
		if (contains(joueur))
			return;
		localisateur.put(joueur, reserve);
		reserve.add(joueur);
		joueur.setField(this);
	}
	/**
	 * Renseigne sur La validit, ou non, d'une place sur le terrain.
	 * 
	 * @param c
	 *            L'element positionnable  tester.
	 * @return <tt>true</tt> si la position existe, <tt>false</tt> sinon.
	 */
	public boolean exist(Positionable c) {
		try {
			getCase(c.getX(), c.getY());
		} catch (CaseInexistanteException cie) {
			return false;
		}
		return true;
	}
	/**
	 * Place la balle sur une case prcise.
	 * 
	 * @param x
	 *            l'abcisse de la case
	 * @param y
	 *            l'ordonne de la case
	 * @return <code>true</true> si la case est occupee<code>false</code> sinon.
	 */
	public boolean placeBallAt(int x, int y) throws CaseInexistanteException {
		if (getCase(x, y).isEmpty()) {
			balle = getCase(x, y);
			return false;
		} else {
			balle = getCase(x, y).getOccupant();
			return true;
		}
	}
	public boolean placeBallAt(Positionable p) throws CaseInexistanteException {
		return placeBallAt(p.getX(), p.getY());
	}
	/**
	 * Renvoie une image d'ou est la balle
	 */
	public Positionable getBallPosition() {
		return balle;
	}
	public boolean isOnTheBorder(Joueur joueur) {
		if (joueur.getX() == terrain.length - 1)
			return true;
		if (joueur.getX() == 0)
			return true;
		if (joueur.getY() == terrain[0].length - 1)
			return true;
		if (joueur.getY() == 0)
			return true;
		return false;
	}
	/**
	 * Une fonction utilise pour savoir si une position appartient  une zone
	 * rectangulaire prcise du terrain.
	 * 
	 * @param toFind
	 *            la position qu'on cherche  situer
	 * @param lim1
	 *            un des coins de la zone
	 * @param lim2
	 *            le coin oppos de la zone
	 * @return <tt>true</tt> si le joueur apparient effectivement  la zone
	 *         spcifie, <tt> false</tt> sinon.
	 */
	protected boolean isInArea(Positionable toFind, Positionable lim1,
			Positionable lim2) {
		int xMin, xMax, yMin, yMax;
		xMin = Math.min(lim1.getX(), lim2.getX());
		xMax = Math.max(lim1.getX(), lim2.getX());
		yMin = Math.min(lim1.getY(), lim2.getY());
		yMax = Math.max(lim1.getY(), lim2.getY());
		if (toFind.getX() < xMin)
			return false;
		if (toFind.getX() > xMax)
			return false;
		if (toFind.getY() < yMin)
			return false;
		if (toFind.getY() > yMax)
			return false;
		return true;
	}
	/**
	 * Renseigne sur l'occupation d'une zone
	 * 
	 * @param lim1
	 *            un des coins de la zone
	 * @param lim2
	 *            Le coin oppos de la zone
	 * @return un Iterator contenant les joueurs de la zone.
	 */
	protected Iterator playersInArea(Positionable lim1, Positionable lim2)
			throws CaseInexistanteException {
		Vector<Joueur> vector = new Vector<Joueur>();
		int xMin, xMax, yMin, yMax;
		Case tmpCase;
		xMin = Math.min(lim1.getX(), lim2.getX());
		xMax = Math.max(lim1.getX(), lim2.getX());
		yMin = Math.min(lim1.getY(), lim2.getY());
		yMax = Math.max(lim1.getY(), lim2.getY());
		for (int i = xMin; i <= xMax; i++)
			for (int j = yMin; j <= yMax; j++) {
				tmpCase = getCase(i, j);
				if (!tmpCase.isEmpty())
					vector.addElement(tmpCase.getOccupant());
			}
		return vector.iterator();
	}
	/**
	 * Un iterator sur les joueurs KO.
	 * @return un iterator sur les joueurs KO.
	 */
	public Iterator kOIterator() {
		return kO.iterator();
	}
	
	/**
	 * Un iterator sur les joueurs en reserve.
	 * @return un ierator sur les joueurs en reserve
	 */
	public Iterator reserveIterator(){
		return reserve.iterator();
	}
	/**
	 * Ajoute un joueur en reserve
	 * @param tmpJ Le joueur a ajouter
	 */
	public void putInReserve(Joueur tmpJ) {
		reserve.add(tmpJ);
	}
	/**
	 * Renvoie out les joueurs presents sur le terrain en reserve
	 */
	public void goBackToLockers() {
		Enumeration enumeration = localisateur.elements();
		Positionable tmpPos;
		while (enumeration.hasMoreElements()) {
			tmpPos = (Positionable) enumeration.nextElement();
			if (exist(tmpPos))
				try {
					placeJoueurAt(getCase(tmpPos).getOccupant(), reserve);
				} catch (Exception e) {
					System.out
							.println("Erreur : exception lors de retour au vestiaire.");
					e.printStackTrace();
				}
		}
	}
	/**
	 * @return Returns the weather.
	 */
	public short getWeather() {
		return weather;
	}
	/**
	 * @param weather
	 *            The weather to set.
	 */
	public void setWeather(short weather) {
		this.weather = weather;
	}
	/**
	 * Renvoie le nombre d'adversaires directement en contact avec le joueur.
	 * 
	 * 
	 * Ne prends pas en compte les capacits spciales "volues", pourrait se
	 * faire en grant un objet Tackledfinition, qui contiendrait diverses
	 * infos. Le constructeur de cet objet contiendrait cette fonction, et
	 * serait li a une classe das les joueurs.
	 * 
	 * @return Le nombre d'adversaires.
	 */
	public int adversairesEnContact(Joueur joueur) {
		Case c = new Case();
		int nbAdv = 0;
		for (int i = -1; i <= 1; i++)
			for (int j = -1; j <= 1; j++) {
				try {
					c = getCase(joueur.getX() + i, joueur.getY() + j);
					if ((!c.isEmpty())
							&& (c.getOccupant().getTeam() != joueur.getTeam()))
						nbAdv++;
				} catch (CaseInexistanteException cie) {
					System.out.println(cie
							+ " a t considre comme hors-plateau");
				}
			}
		return nbAdv;
	}
	/**
	 * Indique la distance entre une position et un joueur.
	 * 
	 * @param p
	 *            La position  partir de laquelle mesurer.
	 * @return la distance
	 */
	public static double distance(Positionable p1, Positionable p2) {
		return Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2)
				+ Math.pow(p1.getY() - p2.getY(), 2));
	}
	public boolean isInATackleZone(Joueur joueur) {
		return (adversairesEnContact(joueur) > 0);
	}
	public void expulse(Joueur joueur, boolean canComeBack)
			throws JoueurInconnuException, IllegalActionException {
		if (canComeBack)
			putInReserve(joueur);
		else {
			putIndAndI(joueur);
			iGotMyEyeOnYou = null;
		}
	}
	public boolean firstFoulBy(Team team) {
		if (iGotMyEyeOnYou == team)
			return false;
		iGotMyEyeOnYou = team;
		return true;
	}
	/**
	 * Renseigne sur les soutients offensifs qu'aura l'adversaire de ce joueur.
	 * Ne prends pas encore en compte les capacits spciales.
	 * 
	 * @param joueur
	 *            Le joueur qu'on test.
	 * @param adversaire
	 *            Son future adversaire.
	 * @return La valeur du soutient.
	 */
	public int soutientContre(Joueur joueur, Joueur adversaire) {
		Case c = new Case();
		int soutient = 0;
		for (int i = -1; i <= 1; i++)
			for (int j = -1; j <= 1; j++) {
				try {
					c = getCase(joueur.getX() + i, joueur.getY() + j);
					if ((!c.isEmpty())
							&& (c.getOccupant().getTeam() != joueur.getTeam())
							&& (c.getOccupant() != adversaire)
							&& (adversairesEnContact(c.getOccupant()) == 1))
						soutient++;
				} catch (CaseInexistanteException cie) {
					// System.out.println(cie + " a t considre comme
					// hors-plateau");
				}
			}
		return soutient;
	}//MISE EN FORME : pourquoi ne pqs deplqcer cette methode dqns regles?
	/**
	 * Renseigne sur l'occupation des zones laterales sur le terrain. Renvoie uu
	 * tableau d'<tt>Iterator</tt>. Les indices 0 et 1 concernent la partie
	 * gauche du terrain, de bas en haut, et les indices 2 et 3, les zones
	 * situes a droite, de bas en haut.
	 * 
	 * @return
	 */
	public Iterator[] playersInLateralZones() {
		Iterator[] toReturn = new Iterator[4];
		try {
			toReturn[0] = this.playersInArea(getCase(1, 0), getCase(halfXSIZE,
					yLateralZone));
			toReturn[1] = this.playersInArea(getCase(1, YSIZE - 1), getCase(
					halfXSIZE, YSIZE - yLateralZone - 1));
			toReturn[2] = this.playersInArea(getCase(halfXSIZE + 1, 0),
					getCase(halfXSIZE * 2 - 1, yLateralZone));
			toReturn[3] = this.playersInArea(getCase(halfXSIZE + 1, YSIZE - 1),
					getCase(halfXSIZE * 2 - 1, YSIZE - yLateralZone - 1));
		} catch (CaseInexistanteException e) {
			// This shouldnt happend
			//assert false;
			System.out.println("Error during the lateral zones look-up");
			e.printStackTrace();
		}
		return toReturn;
	}
	/**
	 * Rensigne sur l'occupation des zones laterales.
	 * 
	 * @return L'index 0 corespond a la moitie gauche du terrain, et l'index 1 a
	 *         la moitie droite.
	 */
	public Iterator[] playersOnScrimmageLine() {
		try {
			Iterator[] toReturn = new Iterator[2];
			toReturn[0] = playersInArea(getCase(xScrimmageLine, 0), getCase(
					xScrimmageLine, YSIZE - 1));
			toReturn[1] = playersInArea(getCase(terrain.length - xScrimmageLine
					- 1, 0), getCase(terrain.length - xScrimmageLine - 1,
					YSIZE - 1));
			return toReturn;
		} catch (CaseInexistanteException e) {
			// This shouldn'nt happened
			e.printStackTrace();
			return null;
		}
	}
	//    public Positionable ballBounce(){
	//        Case bounce = new Case((int)(balle.getX() + Math.random()*3 - 1),(int)(
	// balle.getY() + Math.random()*3 - 1) );
	//        
	//        while(!exist(bounce)){
	//            bounce = new Case((int)(balle.getX() + Math.random()*3 - 1),(int)(
	// balle.getY() + Math.random()*3 - 1) );
	//        }
	//        return bounce;
	//    }
	/**
	 * Fait rebondir la balle d'une case.
	 * 
	 * @return La position de la balle apres le rebond
	 */
	public Positionable ballBounce() {
		boolean goOn = true;
		int xMod, yMod;
		while (goOn) {
			try {
				xMod = (int) Math.floor(Math.random() * 3 - 1);
				yMod = (int) Math.floor(Math.random() * 3 - 1);
				if ((xMod == 0) && (yMod == 0)) {
					continue;
				}
				placeBallAt(balle.getX() + xMod, balle.getY() + yMod);
				System.out.println("La balle a rebondi une fois en " + balle);
				goOn = false;
			} catch (CaseInexistanteException e) {
				goOn = true;
			}
		}
		return balle;
	}
	
	public Joueur getJoueurAt(int x, int y) throws CaseInexistanteException {
		return getCase(x, y).getOccupant();
	}
	
	public Joueur getJoueurAt(Positionable p) throws CaseInexistanteException{
		return getJoueurAt(p.getX(), p.getY());
	}
}