package bbLib;
import java.io.Serializable;
/**
 * Une classe servant a Gerer les joueurs pouvant jouer un match. Compatible
 * avec le TeamBuilder du 20 Fevrier 2004.
 * 8 Septembre 2004 : ajout d'un SerialVersionUID
 * @author Pierre Trocm
 * @version 0.9 - 8 Septembre 2004.
 */
public class Joueur extends RacineJoueur
		implements
			Positionable,
			Cloneable,
			Serializable,
			MessagingChain,
			InterceptionHandler {
	private static final long serialVersionUID = -3161272907524251060L;
	private String name;
	private Team team;
	transient private short etat;
	transient private Field field;
	private int reussites, sorties, interceptions, touchDowns, jpvs;
	private transient int mouvementDisponible, availableSprintSquare;
	private MessagingChain nextMessageHandler;
	private InterceptionHandler interceptionHandler;
	
	public boolean hasTheBall() {
		return (field.getBallPosition() == (Positionable) this);
	}
	public void setTeam(Team team) {
		if (this.team == team)
			return;
		this.team = team;
		setNextMessageHandler(team);
		team.addJoueur(this);
	}
	public void setField(Field field) {
		if (this.field == field)
			return;
		this.field = field;
		field.addJoueur(this);
	}
	/**
	 * Renseigne sur l'abcisse du Joueur
	 * 
	 * @return l'abcisse du joueur.
	 */
	public int getX() {
		try {
			return field.localiser(this).getX();
		} catch (JoueurInconnuException jie) {
			System.out
					.println("Une erreur a eu lieu : ce joueur ne sait plus o est son quipe");
		}
		return -1;
	}
	/**
	 * Renseigne sur l'ordonne du Joueur
	 * 
	 * @return l'ordonne du joueur.
	 */
	public int getY() {
		try {
			return field.localiser(this).getY();
		} catch (JoueurInconnuException jie) {
			System.out
					.println("Une erreur a eu lieu : ce joueur ne sait plus o est son quipe");
		}
		return -1;
	}
	/**
	 * Renvoie la reprsentation du joueur sous forme d'une chaine de
	 * caracteres.
	 * 
	 * @return une chaine de caractere.
	 */
	public String toString() {
		try {
			return name + " (" + movement + "/" + agility + "/" + strenght
					+ "/" + armor + "/" + skills + ") " + " en  "
					+ field.localiser(this);
		} catch (NullPointerException npe) {
			return name + " (" + movement + "/" + agility + "/" + strenght
					+ "/" + armor + "/" + skills + ") ";
		} catch (JoueurInconnuException jie) {
			return "Joueur inconnu! - ereur lors du traitement de votre commande";
		}
	}
	/**
	 * Renseigne sur l'quipe  laquelle appartient ce joueur
	 * 
	 * @return Une Team pointant sur l'quipe de ce joueur
	 */
	public Team getTeam() {
		return team;
	}
	/**
	 * Indique si le joueur est au sol
	 * 
	 * @return <tt>true</tt> si le joueur est au sol, <tt>false</tt> sinon.
	 */
	public boolean isStanding() {
		return (etat == Rules.STANDING);
	}
	/**
	 * @param skill
	 *            The skill to test
	 * @return <tt>true</tt> si le joueur a le skill, <tt>false</tt> sinon
	 */
	public boolean has(String skill) {
		return skills.contains(skill);
	}
	/**
	 * @return Returns the mouvementDisponible.
	 */
	public int getMouvementDisponible() {
		return mouvementDisponible;
	}
	/**
	 * @param mouvementDisponible
	 *            The mouvementDisponible to set.
	 */
	public void removeFromMouvementDisponible(int toRemove)
			throws IllegalActionException {
		if (this.mouvementDisponible < toRemove)
			throw new IllegalActionException();
		this.mouvementDisponible -= toRemove;
	}
	/**
	 * @return Returns the etat.
	 */
	public short getEtat() {
		return etat;
	}
	/**
	 * @return Returns the usedSprintSquare.
	 */
	public int getAvailableSprintSquare() {
		return availableSprintSquare;
	}
	/**
	 * Add one to the usedSprintSquare.
	 */
	public void addUsedSprintSquare() {
		availableSprintSquare--;
	}
	
	public void resetTurn() {
		mouvementDisponible = movement;
		availableSprintSquare = this.has("SPRINT")? 3 : 2;
	}
	/**
	 * @param etat
	 *            The etat to set.
	 */
	public void setEtat(short etat) {
		this.etat = etat;
	}
	/**
	 * @return Returns the field.
	 */
	public Field getField() {
		return field;
	}
	/**
	 * Un constructeur.
	 */
	public Joueur(RacineJoueur modele, String name) {
		super(modele);
		this.name = name;
	}
	/**
	 * Renseigne sur la force du joueur. Ne tient pas compte des ventuels
	 * soutient qu'il pourrait recevoir.
	 * 
	 * @return La force du joueur
	 */
	public int getStrenght() {
		return strenght;
	}
	/**
	 * Renseigne sur l'armure du joueur.
	 * 
	 * @return L'armure du joueur
	 */
	public int getArmor() {
		return armor;
	}
	public int getMovement() {
		return movement;
	}
	public int getAgility() {
		return agility;
	}
	public Capacities getCapacities() {
		return skills;
	}
	/**
	 * @return
	 */
	public String getName() {
		return name;
	}
	public int getXP() {
		return reussites + sorties * 2 + interceptions * 2 + touchDowns * 3
				+ jpvs * 5;
	}
	/**
	 * @return
	 */
	public int getInterceptions() {
		return interceptions;
	}
	/**
	 * @return
	 */
	public int getJpvs() {
		return jpvs;
	}
	/**
	 * @return
	 */
	public int getReussites() {
		return reussites;
	}
	/**
	 * @return
	 */
	public int getSorties() {
		return sorties;
	}
	/**
	 * @return
	 */
	public int getTouchDowns() {
		return touchDowns;
	}
	/**
	 * @param i
	 */
	public void setInterceptions(int i) {
		interceptions = i;
	}
	/**
	 * @param i
	 */
	public void setJpvs(int i) {
		jpvs = i;
	}
	/**
	 * @param i
	 */
	public void setReussites(int i) {
		reussites = i;
	}
	/**
	 * @param i
	 */
	public void setSorties(int i) {
		sorties = i;
	}
	/**
	 * @param i
	 */
	public void setTouchDowns(int i) {
		touchDowns = i;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.ReRollHandler#askForReRoll()
	 */
	public boolean askForReRoll() {
		return team.askForReRoll();
	}
	//GAME MANAGER : ajouter la gestion de l'XP
	//GAME MANAGER : gestion des turnOvers
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.ReRollHandler#usedAReRoll()
	 */
	public void usedAReRoll() {
		nextMessageHandler.usedAReRoll();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.TurnOverHandler#turnOverHappened()
	 */
	public void turnOverHappened() {
		nextMessageHandler.turnOverHappened();
	}
	/**
	 * @return
	 */
	public boolean askForFollowUp() {
		return nextMessageHandler.askForFollowUp();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.PushManager#choseASquare(bbLib.Positionable[])
	 */
	public int choseASquare(Positionable[] choices) {
		return nextMessageHandler.choseASquare(choices);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see bbLib.DiceChoser#choseDice(int[])
	 */
	public int choseDice(int[] dicesResult) {
		return nextMessageHandler.choseDice(dicesResult);
	}
	/* (non-Javadoc)
	 * @see bbLib.InterceptionHandler#askForInterception(bbLib.Joueur[])
	 */
	public int askForInterception(Joueur[] candidats) {
		return interceptionHandler.askForInterception(candidats);
	}
	
	/* (non-Javadoc)
	 * @see bbLib.InterceptionHandler#ballHasBeenIntercepted()
	 */
	public void ballHasBeenIntercepted(Joueur joueur) {
		interceptionHandler.ballHasBeenIntercepted(joueur);
	}
	
	public void interceptedTheBall(){
		interceptionHandler.ballHasBeenIntercepted(this);
	}
/**
 * @param nextMessageHandler The nextMessageHandler to set.
 */
public void setNextMessageHandler(MessagingChain nextMessageHandler) {
	this.nextMessageHandler = nextMessageHandler;
}
	/**
	 * @param interceptionHandler The interceptionHandler to set.
	 */
	public void setInterceptionHandler(InterceptionHandler interceptionHandler) {
		this.interceptionHandler = interceptionHandler;
	}
	/* (non-Javadoc)
	 * @see bbLib.MessagingChain#useSkill(java.lang.String)
	 */
	public boolean useSkill(String skill) {
		return has(skill)? nextMessageHandler.useSkill(skill):false;
	}
}