/*
 * Created on 30 mai 2004
 */
package bbLib;

/**
 * @author Pierre Trocm
 * 1er Juin 2004 : ajout de useSkill
 * @version 0.2 - 1er Juin 2004
 */
public interface MessagingChain {
	
	/**
	 * Answer to a reRoll request
	 * @return <tt>true</tt> if accepted, <tt>false</tt> if refused.
	 */
	public boolean askForReRoll();
	
	/**
	 * Notify the chain that a reRoll has been used
	 */
	public void usedAReRoll();
	

	/**
	 * Demande a la chaine de responsabilite si une poursuite est souhaitee.
	 * @return <code>true</code> si oui, <code>false</code> sinon.
	 */
	boolean askForFollowUp();
	
	/**
	 * Demande de choisir une case parmis plusieurs possible.
	 * 
	 * @param choices Les cases proposes
	 * @return L'index de la case choisie
	 */
	public int choseASquare(Positionable[] choices);
	
	/**
	 * notifie la chaine qu'un turnOver a eu lieu.
	 *
	 */
	public void turnOverHappened();

	/**
	 * Choisit un d par mis ceux proposes.
	 * 
	 * @param dicesResult Le choix de des proposes
	 * @return L'index du d choisi, <code>-1<code> en cas de demande de ReRoll.
	 */
	public int choseDice(int[] dicesResult);
	
	/**
	 * Demande l'utilisation de tel ou tel skill. Utile pour les skill ne povant etre utilises qu'une fois par tour, ou potentiellment negatifs.
	 * @param skill Le skill a tester.
	 * @return <code>true</code> si il est possible de l'utiliser <code>false</code> sinon.
	 */
	public boolean useSkill(String skill);
	
}
