package bbLib;
import java.io.Serializable;
/**
 * Une classe grant un joueur "standard" d'un certain type. Exemple, un passeur humain, sans nom ni equipes, etc...
 * 
 * @author Pierre Trocm
 * 8 Septembre 2004 : ajout d'un SerialVersionUID
 * @version 0.2 - 8 Septembre 2004
 */
public class RacineJoueur implements Serializable
{
	private static final long serialVersionUID = -5876266124704470760L;
	protected CareerOpportunities evolution;
    protected int movement, agility, strenght, armor;
    protected String race, type;
    protected Capacities skills;
    protected int prix;
    protected int indexInReferenceSheet;
    transient private int nbInRoster;//??
    private int nbMax;
    
//    /**
//     * @deprecated ne prend pas en compte le nbMax de joueurs
//     * @param movement
//     * @param strenght
//     * @param agility
//     * @param armor
//     * @param type
//     * @param race
//     * @param skills
//     * @param prix
//     * @param index
//     */
//    public RacineJoueur(int movement, int strenght, int agility, int armor, String type, String race, String skills, int prix, int index)
//    {
//        this.type = type;
//        this.race = race;
//        this.movement = movement;
//        this.agility  = agility;
//        this.strenght = strenght;
//        this.armor = armor;
//        this.prix = prix;
//        this.skills = new Capacities(skills);
//        this.indexInReferenceSheet = index;
//    }
    
    public RacineJoueur(RacineJoueur modele)
    {
        this.type = modele.type;
        this.race = modele.race;
        this.movement = modele.movement;
        this.agility  = modele.agility;
        this.strenght = modele.strenght;
        this.armor = modele.armor;
        this.nbMax = modele.getNbMax();
        this.skills = new Capacities(modele.skills.toString());
        this.evolution = modele.evolution;
    }

    
    public RacineJoueur(int movement, int agility, int strenght, int armor, int prix, String type, String race, int nbMax, String skills, String evolution)
    {
        this.type = type;
        this.race = race;
        this.movement = movement;
        this.agility  = agility;
        this.strenght = strenght;
        this.armor = armor;
        this.skills = new Capacities(skills);
        this.prix = prix;
        this.nbMax = nbMax;
        this.evolution = new CareerOpportunities(evolution);
    }
    
    public String toString(){
        return "0 - " + nbMax + " " + race + " " + type +" (" + movement + "/" + agility + "/" + strenght + "/" + armor+ "-" + skills + ") ";
    }
    
    public int getPrix(){
        return prix;
    }
    
    public boolean oneMoreInRoster(){
        if(nbInRoster >= nbMax) return false;
        nbInRoster++;
        return true;
    }

    public void oneLessInRoster(){
        nbInRoster--;
    }
	/**
	 * @return
	 */
	public int getAgility() {
		return agility;
	}

	/**
	 * @return
	 */
	public int getArmor() {
		return armor;
	}

	/**
	 * @return
	 */
	public int getMovement() {
		return movement;
	}

	/**
	 * @return
	 */
	public int getNbMax() {
		return nbMax;
	}

	/**
	 * @return
	 */
	public String getSkills() {
		return skills.toString();
	}

	/**
	 * @return
	 */
	public int getStrenght() {
		return strenght;
	}

	/**
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * @return Returns the evolution.
	 */
	public String getEvolution() {
		return evolution.toString();
	}
}
