package bbLib;
/**
 * Une classe reprsentant un test, son rultat et ses particularits.
 * 
 * @author Pierre Trocm
 * @version 0.1 - 16 Novembre 2003
 */
public class Test
{
    private int nbDices, difficulty, sum, modifiers;
    private int[] diceResults;
    private boolean hasBeenReRolled;
    
    /**
     * Constructor for objects of class Test
     */
    public Test(int difficulty, int nbDices, int modifiers)
    {
        this.modifiers = modifiers;
        this.nbDices = nbDices;
        this.difficulty = difficulty;
        hasBeenReRolled = false;
        diceResults = new int[nbDices];
        
        sum = 0;
        for(int i = 0; i<nbDices; i++) {
            diceResults[i] = Dices.rollOneDice();
            sum += diceResults[i];
        }
        
//        System.out.println("Test cre. La difficult est de " + difficulty + " le rsultat de "+ sum +". Est-ce un succes? " + succeded());
    }
    
    /**
     * Constructor for objects of class Test
     */
    public Test(int Difficulty, int nbDices)
    {
        this.modifiers = 0;
        this.nbDices = nbDices;
        this.difficulty = Difficulty;
        hasBeenReRolled = false;
        diceResults = new int[nbDices];
        
        sum = 0;
        for(int i = 0; i<nbDices; i++) {
            diceResults[i] = Dices.rollOneDice();
            sum += diceResults[i];
        }
    }
    
    public boolean reRoll(){
        if (hasBeenReRolled == true) return false;
        sum = 0;
        for(int i = 0; i<nbDices; i++) {
            diceResults[i] = Dices.rollOneDice();
            sum += diceResults[i];
        }
        hasBeenReRolled = true;
        return true;
    }
    
    public boolean contains(int score){
        for(int i = 0; i<nbDices; i++) if(diceResults[i] == score) return true;
        return false;
    }
    
    public boolean containsLessThanOne(){
        for(int i = 0; i<nbDices; i++) if(Math.max(diceResults[i], diceResults[i] + modifiers) < 1) return true;
        return false;
    }
    
    public boolean isADouble(){
        if(nbDices != 2) return false;
        if(sum%2 != 0) return false;
        return (contains(sum/2));
    }
    
    public boolean succeded(){
        return (sum + modifiers >= difficulty);
    }
}