/*
 Pon : an Opening Notepad
 Copyright (C) 2005 Pierre Trocm

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//TODO ajouter un cran de loading ave les infos GPL
package pon;

import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * @author Pierre Trocm
 * @version 0.3 - 8 janv. 2005
 */
public class BoardView extends JPanel {
    private static final long serialVersionUID = 5295883073558885937L;

    final static String path = "bitmaps" + java.io.File.separator;

    private boolean whiteIsBottom;

    /**
     * The default contructor. Build a new BoardView displayiig the starting
     * chess position.
     *  
     */
    public BoardView() {
        this("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
    }

    /**
     * The Basic contructor. Build a new boardview displaying the posiion
     * incated by the fen.
     * 
     * @param fen
     *            The fen to set.
     */
    public BoardView(String fen) {
        whiteIsBottom = true;
        setMaximumSize(new Dimension(320, 320));
        setLayout(new GridLayout(0, 8));
        setFen(fen);
    }

    /**
     * Update the displayed position.
     * 
     * @param fen
     *            the Fen to set.
     */
    public void setFen(String fen) {
        removeAll();
        fen = fen.substring(0, fen.indexOf(" "));
        int placees = 0;
        
        if(!whiteIsBottom){
            String[] splittedFen = fen.split("/");
            fen = new String();
            for(String token : splittedFen){
                fen = token + "/" + fen;
            }
        }

        for (int i = 0; i < fen.length(); i++) {
            String pictureName = new String(path);
            char currentChar = fen.charAt(i);

            if (currentChar == '/') {
                continue;
            }
            if (Character.isLetter(currentChar)) {
                //Gnerer le nom de l'image
                //couleurSase/couleurPiece/NomPiece/.gif
                pictureName += ((placees + placees / 8) % 2 == 0) ? 'w' : 'b';
                pictureName += Character.isUpperCase(currentChar) ? 'w' : 'b';
                pictureName += Character.toLowerCase(currentChar);
                pictureName += ".gif";
                //L'ajouter
                Icon icon = new ImageIcon(pictureName);
                add(new JLabel(icon));
                placees++;
            } else {
                int j = new Integer(new String(currentChar + "")).intValue();
                while (j-- > 0) {

                    pictureName = path
                            + (((placees + placees++ / 8) % 2 == 0) ? "wsq.gif"
                                    : "bsq.gif");
                    //L'ajouter
                    add(new JLabel(new ImageIcon(pictureName)));
                }
            }
        }
        validate();
    }

    /**
     * 
     */
    public void swap() {
        whiteIsBottom = ! whiteIsBottom;
    }
}