/*
Pon : an Opening Notepad
Copyright (C) 2005 Pierre Trocm

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
 * Created on 1 janv. 2005
 */
package pon;

import java.io.Serializable;
import java.util.Iterator;

/**
 * A default implementation of <code>ChapitreMember</code>.
 * @author Pierre Trocm
 * @version 0.1 - 1 janv. 2005
 */
public abstract class DefaultChapitreMember implements ChapitreMember,
        Serializable {
    private String name, comments;

    private Chapitre chapitre;


    /**
     * A default constructor
     * @param name the title of this <code>DefaultChapitreMember</code>.
     */
    public DefaultChapitreMember(String name) {
        this.name = name;
        comments = new String();
        chapitre = null;
    }

    /**
     * 
     * @see pon.ChapitreMember#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see pon.ChapitreMember#setName(java.lang.String)
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * @see pon.ChapitreMember#getComments()
     */
    public String getComments() {
        return comments;
    }

    /**
     * @see pon.ChapitreMember#setComments(java.lang.String)
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     * @return Returns the chapitre.
     */
    public Chapitre getChapitre() {
        return chapitre;
    }

    /**
     * @param chapitre
     *            The chapitre to set.
     */
    public void setChapitre(Chapitre chapitre) {
        if (getChapitre() != chapitre) {
            Chapitre oldChapitre = this.chapitre;
            this.chapitre = chapitre;
            if (oldChapitre != null) {
                oldChapitre.remove(this);
            }
            if (chapitre != null) {
                chapitre.add(this);
            }
        }
    }

    /**
     * 
     * @see java.lang.Iterable#iterator()
     */
    public abstract Iterator<ChapitreMember> iterator();

}