/*
Pon : an Opening Notepad
Copyright (C) 2005 Pierre Trocm

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package pon;

import ictk.boardgame.chess.ChessGame;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * Created on 26 dc. 2004
 */

/**
 * @author Pierre Trocm
 * @version 0.1 - 26 dc. 2004
 */
public class MovePanel extends JPanel {
    private static final long serialVersionUID = 1694054143677455564L;

    private List<MoveView> list;

    public MovePanel() {
        super();
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        list = new ArrayList<MoveView>();
    }

    /**
     * @deprecated remplace par add(List)
     * @param moveView
     */
    public void add(MoveView moveView) {
        super.add(moveView);
        list.add(moveView);
    }

    /**
     * @param list
     */
    public void add(Iterable<MoveView> list) {
        FENHandler handler;
        MoveView stocked = null;

        for (MoveView moveView : list) {
            try {
                handler = new FENHandler(moveView.getResultingFen());
                if (handler.getSideToMove() == ChessGame.BLACK) {
                    //Le coup devait donc etre jou depuis uue position blanche
                    if (stocked == null) {
                        stocked = moveView;
                    } else {
                        super.add(new MoveCouple(handler.getMoveNumber(),
                                stocked, null, stocked.getVariationLevel()));
                        stocked = moveView;
                    }
                } else {
                    if (stocked != null
                            && (stocked.getVariationLevel() != moveView
                                    .getVariationLevel() || FENHandler
                                    .getMoveNumber(stocked.getResultingFen()) != FENHandler
                                    .getMoveNumber(moveView.getResultingFen()) - 1)) {
                        super.add(new MoveCouple(FENHandler
                                .getMoveNumber(stocked.getResultingFen()),
                                stocked, null, stocked.getVariationLevel()));
                        super.add(new MoveCouple(FENHandler
                                .getMoveNumber(moveView.getResultingFen()) - 1,
                                null, moveView, moveView.getVariationLevel()));
                    } else {
                        super.add(new MoveCouple(handler.getMoveNumber() - 1,
                                stocked, moveView, moveView.getVariationLevel()));
                    }
                    stocked = null;
                }
            } catch (IOException e) {
                e.printStackTrace();
                break;
            }
        }
        if (stocked != null) {
            try {
                handler = new FENHandler(stocked.getResultingFen());
                add(new MoveCouple(handler.getMoveNumber(), stocked, null, stocked.getVariationLevel()));
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        super.add(Box.createVerticalGlue());
        for (MoveView moveView : list) {
            this.list.add(moveView);
        }
    }

    public MoveView add(TreeListIterator<MoveView> list, MoveView from,
            MoveView stocked) {
        FENHandler handler;
        MoveView moveView = from;
        try {
            handler = new FENHandler(moveView.getResultingFen());
            if (handler.getSideToMove() == ChessGame.BLACK) {
                //Le coup devait donc etre jou depuis uue position blanche
                if (stocked == null) {
                    stocked = moveView;
                } else {
                    super.add(new MoveCouple(handler.getMoveNumber(), stocked,
                            null, stocked.getVariationLevel()));
                    stocked = moveView;
                }
            } else {
                if (stocked != null
                        && (stocked.getVariationLevel() != moveView
                                .getVariationLevel() || FENHandler
                                .getMoveNumber(stocked.getResultingFen()) != FENHandler
                                .getMoveNumber(moveView.getResultingFen()) - 1)) {
                    super.add(new MoveCouple(FENHandler.getMoveNumber(stocked
                            .getResultingFen()), stocked, null, stocked.getVariationLevel()));
                    super.add(new MoveCouple(FENHandler.getMoveNumber(moveView
                            .getResultingFen()) - 1, null, moveView, moveView.getVariationLevel()));
                } else {
                    super.add(new MoveCouple(handler.getMoveNumber() - 1,
                            stocked, moveView, moveView.getVariationLevel()));
                }
                stocked = null;
            }
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

        for (int i = 0, n = list.getBranchCount(); i < n; i++) {
            stocked = add(list, list.next(i), stocked);
            list.selectElement(from);
        }
        return stocked;
    }

    public void add(TreeListIterator<MoveView> list) {
        list.selectFirstElement();
        if (list.hasNext()) {
            MoveView stocked = add(list, list.next(), null);
            if (stocked != null) {
                try {
                    FENHandler handler = new FENHandler(stocked
                            .getResultingFen());
                    add(new MoveCouple(handler.getMoveNumber(), stocked, null, stocked.getVariationLevel()));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            super.add(Box.createVerticalGlue());
            for (MoveView moveView : list) {
                this.list.add(moveView);
            }
        }
    }

    public ListIterator<MoveView> listIterator() {
        return list.listIterator();
    }

    public ListIterator<MoveView> listIterator(MoveView moveView) {
        return list.listIterator(list.indexOf(moveView));
    }

    public List<MoveView> getList() {
        return list;
    }

    private class MoveCouple extends JPanel implements Cloneable {
        private static final long serialVersionUID = -8046087811485687619L;

        private int moveNumber;

        private static final int VariationOffset = 20;

        private MoveCouple(int moveNumber, int varationLevel) {
            setMaximumSize(new Dimension(200, 200));
            setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
            this.moveNumber = moveNumber;
            for(int i = 0; i<varationLevel; i++){
                add(Box.createHorizontalStrut(VariationOffset));                
            }
            add(new JLabel(moveNumber + ". "));
        }

        public MoveCouple(int moveNumber, MoveView whiteMove, MoveView blackMove, int variationLevel) {
            this(moveNumber, variationLevel);
            if (whiteMove != null) {
                add(whiteMove);
            } else {
                add(new JLabel("..."));
            }
            add(Box.createHorizontalGlue());
            if (blackMove != null) {
                add(blackMove);
            }
            //            add(Box.createHorizontalGlue());

        }

        /**
         * @return Returns the moveNumber.
         */
        public int getMoveNumber() {
            return moveNumber;
        }
    }
}