/*
Pon : an Opening Notepad
Copyright (C) 2005 Pierre Trocm

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


package pon;
import java.awt.event.MouseListener;

import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * 
 * @author Pierre Trocm
 * @version 0.2 - 26 dc. 2004
 */
public class MoveView extends JPanel {
    private static final long serialVersionUID = -2580397092179955557L;

    private Maillon maillon;

    private String resultingFen;

    private int variationLevel;

    private String annotation;

    private boolean selected;
    
    private JLabel label;

    public MoveView(MouseListener mouseListener, String resultingFen,
            Maillon element) {
        this(mouseListener, resultingFen, element, 0);
    }
    
    public MoveView(String resultingFen, Maillon element, int variationLevel) {
        this(null, resultingFen, element, variationLevel);
    }

    public MoveView(MouseListener mouseListener, String resultingFen,
            Maillon element, String annotation) {
        this(mouseListener, resultingFen, element, 0, annotation);
    }

    public MoveView(MouseListener mouseListener, String resultingFen,
            Maillon element, int variationLevel) {
        this(mouseListener, resultingFen, element, variationLevel, "");
    }

    public MoveView(String resultingFen,
            Maillon element, int variationLevel, String annotation) {
        this(null, resultingFen, element, variationLevel, annotation);

    }
    
    public MoveView(MouseListener mouseListener, String resultingFen,
            Maillon element, int variationLevel, String annotation) {
        this.maillon = element;
        addMouseListener(mouseListener);
        this.resultingFen = resultingFen;
        this.variationLevel = variationLevel;
        this.annotation = annotation;
        selected = false;
        label = new JLabel();

        updateLabel();
    }

    /**
     *  
     */
    private void updateLabel() {
        removeAll();
        label = new JLabel();
        String toSet = maillon.getMove();
        String prefix = "<html>";
        String sufix =  new String();
        
        if(!isMainLine()){
            prefix += "<i>";
            sufix  = "</i>" + sufix;
        }
        if(selected){
            prefix += "<u>";
            sufix  = "</u>" + sufix;
        }
        
       label.setText(prefix + toSet + sufix + " " + annotation + "</html>");
       add(label);
       validate();
    }

    /**
     * @return
     */
    private boolean isMainLine() {
        return variationLevel == 0;
    }

    /**
     * @return Returns the maillon.
     */
    public Maillon getMaillon() {
        return maillon;
    }
    
    /**
     * @return Returns the resultingFen.
     */
    public String getResultingFen() {
        return resultingFen;
    }
    
    
    /**
     * Met  jour le label de ce MoveView en fonction de son ventuelle slction.
     * @param selected
     */
    public void setSelected(boolean selected) {
        this.selected = selected;
        updateLabel();
    }
    
    
    /**
     * @return Returns the variationLevel.
     */
    public int getVariationLevel() {
        return variationLevel;
    }
    
    public String toString(){
        return label.getText();
    }
    /**
     * @return
     */
    public Page getPage() {
        return maillon.getPage();
    }
    
    /**
     * @param page
     */
    public void setPage(Page page) {
        maillon.setPage(page);
    }
}