/*
Pon : an Opening Notepad
Copyright (C) 2005 Pierre Trocm

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package pon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/**
 * Une Page du carnet.
 * @author Pierre Trocm
 * @version 0.5 - 1er jan. 2005
 */
public class Page extends DefaultChapitreMember implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String StartFEN = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1";
	private String fen, prefixFen;
	private boolean jouee;
    private Maillon firstMaillon;
    private transient boolean loaded;
    private List<Maillon> prefix;

	public Page(){
	    this("Page sans titre");
	}
	
	public Page(String name){
		this(name, StartFEN);
	}

	public Page(String name, String fen){
		this(name, fen, true);
	}

	public Page(String name, String fen, boolean jouee){
	    super(name);
		this.fen = fen;
		this.jouee = jouee;
		loaded = false;
		prefix = new ArrayList<Maillon>();
	}

	public String getRootFen(){
		return fen;
	}

	public String toString(){
		return getName();
	}
    
    
    /**
     * @return Returns the fen.
     */
    public String getFen() {
        return fen;
    }
    
    
    /**
     * @return Returns the jouee.
     */
    public boolean isJouee() {
        return jouee;
    }
    /**
     * @param jouee The jouee to set.
     */
    public void setJouee(boolean jouee) {
        this.jouee = jouee;
    }

    /**
     * Un itrator Vide (une page ne contient aucun sous chapitre).
     * @see java.lang.Iterable#iterator()
     */
    public Iterator<ChapitreMember> iterator() {
        return new Iterator<ChapitreMember>(){

            public boolean hasNext() {
                return false;
            }

            public ChapitreMember next() {
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }};
    }
    
    public boolean isFirstMoveSet(){
        return firstMaillon != null;
    }
    
    public String getFirstMove() {
        return firstMaillon.getMove();
    }
    
    /**
     * @return Returns the firstMaillon.
     */
    public Maillon getFirstMaillon() {
        return firstMaillon;
    }
    
    /**
     * @param firstMaillon The firstMaillon to set.
     */
    public void setFirstMaillon(Maillon firstMaillon) {
        this.firstMaillon = firstMaillon;
    }
    
    
    /**
     * @return Returns the loaded.
     */
    public boolean isLoaded() {
        return loaded;
    }
    
    /**
     * @param loadIndex The loadIndex to set.
     */
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }
    
    
    public void setFen(String fen) {
        this.fen = fen;
    }
    
    public List<Maillon> getPrefix(){
        return prefix;
    }

    /**
     * @param currentMaillon
     */
    public void addToPrefix(Maillon maillon) {
        prefix.add(maillon);
    }
    
    
    public String getPrefixFen() {
        return prefixFen;
    }
    public void setPrefixFen(String prefixFen) {
        this.prefixFen = prefixFen;
    }
}
