/*
 Pon : an Opening Notepad
 Copyright (C) 2005 Pierre Trocm

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * Created on 3 janv. 2005
 */
package pon;

import java.util.Iterator;

/**
 * @author Pierre Trocm
 * @version 0.1 - 3 janv. 2005
 */
public interface TreeListIterator<E> extends Iterable<E> {
    /*
     * (non-Javadoc)
     *  
     */public boolean hasNext();

    /*
     * (non-Javadoc)
     *  
     */public E next();

    /*
     * (non-Javadoc)
     *  
     */public boolean hasPrevious();

    /**
     * Move the cursor one step backward and give the element which was just
     * pervious it.
     * 
     * @return the previous element.
     * @throws java.util.NoSuchElementException
     *             if the TreeListIterator doesnt contains any more element.
     */
    public E previous();

    /**
     * WARNING : unsupported Operation
     *  
     */
    public void remove();

    public void set(E o);

    public void add(E o);

    public void add(E previous, E element, boolean createBranch);

    public int getBranchCount();

    /**
     * @param index
     * @return
     */
    public E next(int index);

    /**
     * @see pon.TreeListIterator#selectElement(pon.E)
     */
    public void selectElement(E arg0);

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Iterable#iterator()
     */public Iterator<E> iterator();

    /*
     * (non-Javadoc)
     * 
     * @see pon.TreeListIterator#selectFirstElement()
     */public void selectFirstElement();

    public void setMainContinuation(E mainContinuation);

}